/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Configuration {
    private static final String ERROR_ON_MISMATCH = "grabPopulatorErrorOnMismatch";
    private static final String ADD_AT_END = "grabPopulatorAddAtEnd";
    private static final String VERIFY_DEPS = "grabPopulatorVerifyDependencies";
    private boolean errorOnMismatch = true;
    private boolean verifyDependencies = true;
    private boolean atEnd = true;
    @JacksonXmlElementWrapper(localName="include")
    @JacksonXmlProperty(localName="directory")
    private final List<String> directories = Collections.emptyList();

    public void updateConfiguration(Properties sProperties, Properties uProperties) {
        Properties unified = new Properties();
        unified.putAll((Map<?, ?>)sProperties);
        unified.putAll((Map<?, ?>)uProperties);
        if (unified.containsKey(ERROR_ON_MISMATCH)) {
            this.errorOnMismatch = Boolean.parseBoolean(unified.getProperty(ERROR_ON_MISMATCH));
        }
        if (unified.containsKey(ADD_AT_END)) {
            this.atEnd = Boolean.parseBoolean(unified.getProperty(ADD_AT_END));
        }
        if (unified.containsKey(VERIFY_DEPS)) {
            this.verifyDependencies = Boolean.parseBoolean(unified.getProperty(VERIFY_DEPS));
        }
    }

    public String toString() {
        return "Configuration(errorOnMismatch=" + this.isErrorOnMismatch() + ", verifyDependencies=" + this.isVerifyDependencies() + ", atEnd=" + this.isAtEnd() + ", directories=" + this.getDirectories() + ")";
    }

    public boolean isErrorOnMismatch() {
        return this.errorOnMismatch;
    }

    public boolean isVerifyDependencies() {
        return this.verifyDependencies;
    }

    public boolean isAtEnd() {
        return this.atEnd;
    }

    public List<String> getDirectories() {
        return this.directories;
    }
}

