/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.project.MavenProject;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.goots.maven.extensions.grabdependencypopulator.Configuration;
import org.goots.maven.extensions.grabdependencypopulator.GrabParser;
import org.goots.maven.extensions.grabdependencypopulator.ManifestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class GrabEventSpy
extends AbstractEventSpy {
    private static final String DISABLE_GRAB_EXTENSION = "grabPopulatorDisable";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ObjectMapper mapper = new XmlMapper();
    private final GrabParser grabParser;

    @Inject
    public GrabEventSpy(GrabParser lp) {
        this.grabParser = lp;
    }

    public void onEvent(Object event) {
        ExecutionEvent ee;
        ExecutionEvent.Type type;
        if ("true".equalsIgnoreCase(System.getProperty(DISABLE_GRAB_EXTENSION)) || "true".equalsIgnoreCase(System.getenv(DISABLE_GRAB_EXTENSION))) {
            return;
        }
        if (event instanceof ExecutionEvent && (type = (ee = (ExecutionEvent)event).getType()) == ExecutionEvent.Type.SessionStarted) {
            try {
                String repoList;
                File configurationFle = new File(ee.getSession().getRequest().getBaseDirectory(), ".mvn" + File.separator + "grabDependencyPopulator.xml");
                this.logger.debug("Checking for {} ", (Object)configurationFle);
                Configuration config = configurationFle.exists() ? (Configuration)this.mapper.readValue(configurationFle, Configuration.class) : new Configuration();
                config.updateConfiguration(ee.getSession().getSystemProperties(), ee.getSession().getUserProperties());
                this.logger.info("Activating GrabDependencyPopulator extension {}", (Object)ManifestUtils.getManifestInformation());
                MavenProject p = ee.getProject();
                this.grabParser.setErrorOnMismatch(config.isErrorOnMismatch());
                this.grabParser.searchGroovyFiles(p.getBasedir(), config.getDirectories());
                if (this.grabParser.getDependencies().size() > 0) {
                    if (config.isVerifyDependencies()) {
                        if (p.getModel().getDependencyManagement() != null) {
                            this.verifyDeps(false, this.grabParser.getDependencies().values(), p.getModel().getDependencyManagement().getDependencies());
                        }
                        this.verifyDeps(true, this.grabParser.getDependencies().values(), p.getModel().getDependencies());
                    }
                    if (this.logger.isInfoEnabled()) {
                        repoList = this.grabParser.getDependencies().values().stream().sorted(Comparator.comparing(Dependency::getGroupId)).map(v -> "\t" + v).collect(Collectors.joining(System.lineSeparator()));
                        this.logger.info("Adding to project the dependencies{}{}", (Object)System.lineSeparator(), (Object)repoList);
                    }
                    p.getModel().getDependencies().addAll(config.isAtEnd() ? p.getModel().getDependencies().size() : 0, this.grabParser.getDependencies().values());
                }
                if (this.grabParser.getRepositories().size() > 0) {
                    repoList = this.grabParser.getRepositories().stream().sorted(Comparator.comparing(RepositoryBase::getId)).map(r -> "\t" + r.getId() + " -> " + r.getUrl()).collect(Collectors.joining(System.lineSeparator()));
                    this.logger.info("Adding to project the repositories{}{}", (Object)System.lineSeparator(), (Object)repoList);
                }
            }
            catch (ManipulationUncheckedException e) {
                ee.getSession().getResult().addException(e.getCause());
            }
            catch (IOException e) {
                this.logger.error("Caught ", (Throwable)e);
                ee.getSession().getResult().addException((Throwable)new ManipulationException("Error searching groovy files", (Throwable)e, new Object[0]));
            }
        }
    }

    private void verifyDeps(boolean warnOnMatch, Collection<Dependency> grabbedDeps, List<Dependency> targetDeps) {
        grabbedDeps.forEach(d -> targetDeps.forEach(t -> {
            if (t.getGroupId().equals(d.getGroupId()) && t.getArtifactId().equals(d.getArtifactId())) {
                if (!d.getVersion().equals(t.getVersion())) {
                    this.logger.error("Mismatched version between Grab ({}) and native dependency ({})", d, t);
                    throw new ManipulationUncheckedException((Throwable)new ManipulationException("Mismatched version between Grab and native dependencies." + d + " and " + t, new String[0]));
                }
                if (warnOnMatch) {
                    this.logger.warn("Duplicate dependency definition between Grab ({}) and native dependency ({})", d, t);
                }
            }
        }));
    }
}

