/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.extensions.grabdependencypopulator;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.ManipulationUncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrabParser {
    private static final Pattern GRAB_PATTERN_SINGLE = Pattern.compile("@Grab.*[\"'](.+):(.+):(.+)[\"'].*");
    private static final Pattern GRAB_PATTERN_MULTIPLE = Pattern.compile("@Grab.*group=[\"'](.+)[\"'].*module=[\"'](.+)[\"'].*version=[\"'](.+)[\"'].*");
    private static final Pattern GRAB_RESOLVER_PATTERN_MULTIPLE = Pattern.compile("@GrabResolver.*name=[\"'](.+)[\"'].*root=[\"'](.+)[\"'].*");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean errorOnMismatch;
    private final HashMap<ProjectRef, Dependency> dependencies = new HashMap();
    private final Set<Repository> repositories = new HashSet<Repository>();

    private void searchFile(Path target) {
        this.logger.debug("Processing {}", (Object)target);
        Files.readAllLines(target).stream().filter(s -> s.contains("@Grab")).forEach(s -> {
            s = s.replaceAll("\\s+", "");
            Matcher gs = GRAB_PATTERN_SINGLE.matcher((CharSequence)s);
            Matcher gm = GRAB_PATTERN_MULTIPLE.matcher((CharSequence)s);
            Matcher gr = GRAB_RESOLVER_PATTERN_MULTIPLE.matcher((CharSequence)s);
            if (gs.matches()) {
                Dependency d = this.processDependency(this.dependencies, gs.group(1), gs.group(2), gs.group(3));
                this.logger.debug("Matched {} and got version {}", s, (Object)d);
            } else if (gm.matches()) {
                Dependency d = this.processDependency(this.dependencies, gm.group(1), gm.group(2), gm.group(3));
                this.logger.debug("Matched {} and got version {}", s, (Object)d);
            } else if (gr.matches()) {
                Repository r = new Repository();
                r.setId(gr.group(1));
                r.setUrl(gr.group(2));
                this.repositories.add(r);
            } else {
                this.logger.debug("No match for {}", s);
            }
        });
    }

    private Dependency processDependency(HashMap<ProjectRef, Dependency> result, String group, String artifact, String version) {
        Dependency d = new Dependency();
        d.setGroupId(group);
        d.setArtifactId(artifact);
        d.setVersion(version);
        SimpleProjectRef pr = new SimpleProjectRef(group, artifact);
        Dependency existing = result.get(pr);
        if (existing != null && !version.equals(existing.getVersion())) {
            if (this.errorOnMismatch) {
                this.logger.error("Multiple dependencies with different versions detected: {} versus {}", (Object)d, (Object)result.get(pr));
                throw new ManipulationUncheckedException((Throwable)new ManipulationException("GrabDependencyPopulator failed due to a version clash (" + d + " versus " + result.get(pr) + ")", new String[0]));
            }
            this.logger.warn("Multiple dependencies with different versions detected: {} versus {}", (Object)d, (Object)result.get(pr));
        }
        result.put((ProjectRef)pr, d);
        return d;
    }

    public void searchGroovyFiles(File root, List<String> dirs) throws IOException {
        ArrayList<Path> directories = new ArrayList<Path>();
        Path rootPath = root.toPath();
        if (dirs.isEmpty()) {
            directories.add(rootPath);
        } else {
            dirs.forEach(d -> directories.add(new File(root, (String)d).toPath()));
        }
        for (Path r : directories) {
            if (!r.toFile().exists()) {
                throw new IOException("No such directory '" + r + "' to start search from.");
            }
            Files.find(r, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && filePath.getFileName().toString().endsWith(".groovy"), new FileVisitOption[0]).filter(f -> {
                Path relative = rootPath.relativize((Path)f);
                for (int i = 0; i < relative.getNameCount(); ++i) {
                    if (!"target".equals(relative.getName(i).toString())) continue;
                    return false;
                }
                return true;
            }).forEach(this::searchFile);
        }
    }

    public void setErrorOnMismatch(boolean errorOnMismatch) {
        this.errorOnMismatch = errorOnMismatch;
    }

    public HashMap<ProjectRef, Dependency> getDependencies() {
        return this.dependencies;
    }

    public Set<Repository> getRepositories() {
        return this.repositories;
    }
}

