/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystemSession;
import org.goots.maven.ModuleReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplifiedCli {
    private final Logger slf4jLogger = LoggerFactory.getLogger(this.getClass());
    private final MavenCli.CliRequest cliRequest;

    public SimplifiedCli(String[] args) {
        this.cliRequest = new MavenCli.CliRequest(args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() throws Exception {
        MavenCli mavenCli = new MavenCli();
        this.slf4jLogger.debug("Module analyser {} with SHA {} ", (Object)ModuleReader.class.getPackage().getImplementationVersion(), (Object)this.getScmRevision());
        PlexusContainer localContainer = null;
        try {
            this.invokeMaven("initialize", mavenCli, this.cliRequest);
            this.invokeMaven("cli", mavenCli, this.cliRequest);
            this.invokeMaven("logging", mavenCli, this.cliRequest);
            this.invokeMaven("version", mavenCli, this.cliRequest);
            this.invokeMaven("properties", mavenCli, this.cliRequest);
            localContainer = (PlexusContainer)this.invokeMaven("container", mavenCli, this.cliRequest);
            this.invokeMaven("commands", mavenCli, this.cliRequest);
            this.invokeMaven("settings", mavenCli, this.cliRequest);
            MavenExecutionRequest executionRequest = (MavenExecutionRequest)this.invokeMaven("populateRequest", mavenCli, this.cliRequest);
            this.invokeMaven("encryption", mavenCli, this.cliRequest);
            this.invokeMaven("repository", mavenCli, this.cliRequest);
            int n = this.executeModuleSearch(localContainer, executionRequest);
            return n;
        }
        catch (MavenCli.ExitException e) {
            int n = e.exitCode;
            return n;
        }
        finally {
            if (localContainer != null) {
                localContainer.dispose();
            }
        }
    }

    private int executeModuleSearch(PlexusContainer container, MavenExecutionRequest executionRequest) throws Exception {
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        MavenExecutionRequestPopulator populator = (MavenExecutionRequestPopulator)container.lookup(MavenExecutionRequestPopulator.class);
        Maven maven = (Maven)container.lookup(Maven.class);
        populator.populateDefaults(executionRequest);
        RepositorySystemSession repoSession = ((DefaultMaven)maven).newRepositorySession(executionRequest);
        MavenSession session = new MavenSession(container, repoSession, executionRequest, (MavenExecutionResult)result);
        List projects = (List)this.invokeMaven("getProjectsForMavenReactor", maven, session);
        session.setAllProjects(projects);
        Method projectDependencyGraphMethod = maven.getClass().getDeclaredMethod("createProjectDependencyGraph", Collection.class, MavenExecutionRequest.class, MavenExecutionResult.class, Boolean.TYPE);
        projectDependencyGraphMethod.setAccessible(true);
        ProjectDependencyGraph projectDependencyGraph = (ProjectDependencyGraph)projectDependencyGraphMethod.invoke((Object)maven, projects, executionRequest, result, true);
        this.slf4jLogger.debug("ProjectDependencyGraph is " + projectDependencyGraph);
        projectDependencyGraph.getSortedProjects().forEach(p -> this.slf4jLogger.info("{}:{}:{}", new Object[]{p.getGroupId(), p.getArtifactId(), p.getVersion()}));
        return 1;
    }

    private Object invokeMaven(String operation, Object object, Object parameter) throws Exception {
        try {
            Method m = object.getClass().getDeclaredMethod(operation, parameter.getClass());
            m.setAccessible(true);
            return m.invoke(object, parameter);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("Unable to invoke method", e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                throw (Exception)e.getTargetException();
            }
            throw new Exception("Unable to invoke target", e);
        }
    }

    private String getScmRevision() {
        String scmRevision = "unknown";
        try {
            Enumeration<URL> resources = ModuleReader.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL jarUrl = resources.nextElement();
                if (!jarUrl.getFile().contains("module-reader")) continue;
                Manifest manifest = new Manifest(jarUrl.openStream());
                String manifestValue = manifest.getMainAttributes().getValue("Scm-Revision");
                if (manifestValue != null && !manifestValue.isEmpty()) {
                    scmRevision = manifestValue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.slf4jLogger.error("Unexpected exception processing jar file", (Throwable)e);
        }
        return scmRevision;
    }
}

