/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.logging;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.cli.logging.Slf4jConfiguration;
import org.apache.maven.cli.logging.impl.UnsupportedSlf4jBindingConfiguration;
import org.codehaus.plexus.util.PropertyUtils;
import org.slf4j.ILoggerFactory;

public class Slf4jConfigurationFactory {
    public static final String RESOURCE = "META-INF/maven/slf4j-configuration.properties";

    public static Slf4jConfiguration getConfiguration(ILoggerFactory loggerFactory) {
        LinkedHashMap<URL, Set<Object>> supported = new LinkedHashMap<URL, Set<Object>>();
        String slf4jBinding = loggerFactory.getClass().getCanonicalName();
        try {
            Enumeration<URL> resources = Slf4jConfigurationFactory.class.getClassLoader().getResources(RESOURCE);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Properties conf = PropertyUtils.loadProperties(resource.openStream());
                String impl = conf.getProperty(slf4jBinding);
                if (impl != null) {
                    return (Slf4jConfiguration)Class.forName(impl).newInstance();
                }
                supported.put(resource, conf.keySet());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return new UnsupportedSlf4jBindingConfiguration(slf4jBinding, supported);
    }
}

