/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersionRange
implements VersionRange {
    private final VersionRange.Bound lowerBound;
    private final VersionRange.Bound upperBound;

    public GenericVersionRange(String range) throws InvalidVersionSpecificationException {
        GenericVersion lowerBound;
        GenericVersion upperBound;
        boolean upperBoundInclusive;
        boolean lowerBoundInclusive;
        String process = range;
        if (range.startsWith("[")) {
            lowerBoundInclusive = true;
        } else if (range.startsWith("(")) {
            lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must start with either [ or (");
        }
        if (range.endsWith("]")) {
            upperBoundInclusive = true;
        } else if (range.endsWith(")")) {
            upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", a range must end with either [ or (");
        }
        process = process.substring(1, process.length() - 1);
        int index = process.indexOf(",");
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", single version must be surrounded by []");
            }
            lowerBound = upperBound = new GenericVersion(process.trim());
        } else {
            String parsedLowerBound = process.substring(0, index).trim();
            String parsedUpperBound = process.substring(index + 1).trim();
            if (parsedUpperBound.contains(",")) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", bounds may not contain additional ','");
            }
            lowerBound = parsedLowerBound.length() > 0 ? new GenericVersion(parsedLowerBound) : null;
            GenericVersion genericVersion = upperBound = parsedUpperBound.length() > 0 ? new GenericVersion(parsedUpperBound) : null;
            if (upperBound != null && lowerBound != null && upperBound.compareTo(lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(range, "Invalid version range " + range + ", lower bound must not be greater than upper bound");
            }
        }
        this.lowerBound = lowerBound != null ? new VersionRange.Bound(lowerBound, lowerBoundInclusive) : null;
        this.upperBound = upperBound != null ? new VersionRange.Bound(upperBound, upperBoundInclusive) : null;
    }

    @Override
    public VersionRange.Bound getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public VersionRange.Bound getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.lowerBound.isInclusive()) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.upperBound.isInclusive()) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GenericVersionRange that = (GenericVersionRange)obj;
        return GenericVersionRange.eq(this.upperBound, that.upperBound) && GenericVersionRange.eq(this.lowerBound, that.lowerBound);
    }

    private static <T> boolean eq(T s1, T s2) {
        return s1 != null ? s1.equals(s2) : s2 == null;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + GenericVersionRange.hash(this.upperBound);
        hash = hash * 31 + GenericVersionRange.hash(this.lowerBound);
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(64);
        if (this.lowerBound != null) {
            buffer.append(this.lowerBound.isInclusive() ? (char)'[' : '(');
            buffer.append(this.lowerBound.getVersion());
        } else {
            buffer.append('(');
        }
        buffer.append(',');
        if (this.upperBound != null) {
            buffer.append(this.upperBound.getVersion());
            buffer.append(this.upperBound.isInclusive() ? (char)']' : ')');
        } else {
            buffer.append(')');
        }
        return buffer.toString();
    }
}

