/*
 * Decompiled with CFR 0.152.
 */
package org.goots.maven.plugins;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.validation.ModelValidator;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="add-pom", defaultPhase=LifecyclePhase.INSTALL)
public class AttachInstallDeployPOMMojo
extends AbstractMojo {
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");
    private static final String DEFAULT_INSTALL_PLUGIN_VERSION = "2.5.2";
    private static final String DEFAULT_DEPLOY_PLUGIN_VERSION = "2.8.2";
    @Component
    private ModelValidator modelValidator;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    @Component
    private MavenSession mavenSession;
    @Component
    private BuildPluginManager pluginManager;
    @Component
    private ArtifactDeployer deployer;
    @Component
    ArtifactRepositoryFactory repositoryFactory;
    @Parameter(property="altDeploymentRepository")
    private String altDeploymentRepository;
    @Parameter(property="altSnapshotDeploymentRepository")
    private String altSnapshotDeploymentRepository;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(required=true)
    private File pomName;
    @Parameter(required=true)
    private String artifactId;
    @Parameter(required=true)
    private String groupId;
    @Parameter(property="add-pom.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean errorOnMissing;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping plugin");
            return;
        }
        String installPluginVersion = DEFAULT_INSTALL_PLUGIN_VERSION;
        Plugin p = this.mavenProject.getPlugin("org.apache.maven.plugins:maven-install-plugin");
        if (p != null) {
            installPluginVersion = p.getVersion();
        }
        String deployPluginVersion = DEFAULT_DEPLOY_PLUGIN_VERSION;
        p = this.mavenProject.getPlugin("org.apache.maven.plugins:maven-deploy-plugin");
        if (p != null) {
            deployPluginVersion = p.getVersion();
        }
        if (!this.pomName.exists()) {
            if (this.errorOnMissing) {
                throw new MojoExecutionException("Unable to find pomName " + this.pomName + " to install/deploy.");
            }
            this.getLog().warn((CharSequence)("Unable to find " + this.pomName));
            return;
        }
        this.getLog().debug((CharSequence)("Running maven-install-plugin for " + this.pomName + " to target location " + this.groupId + ':' + this.artifactId + ':' + this.mavenProject.getVersion()));
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-install-plugin"), (String)MojoExecutor.version((String)installPluginVersion)), (String)MojoExecutor.goal((String)"install-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)this.pomName.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)this.artifactId), MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.groupId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.mavenProject.getVersion()), MojoExecutor.element((String)MojoExecutor.name((String)"packaging"), (String)"pom")}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.mavenProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        MavenProject tmpProject = new MavenProject();
        tmpProject.setPluginArtifactRepositories(this.mavenProject.getPluginArtifactRepositories());
        this.mavenSession.setCurrentProject(tmpProject);
        try {
            ArtifactRepository repo = this.getDeploymentRepository(this.mavenProject, this.altDeploymentRepository, this.altSnapshotDeploymentRepository);
            this.getLog().debug((CharSequence)("Running maven-deploy-plugin for " + this.pomName + " to target location " + repo.getUrl()));
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-deploy-plugin"), (String)MojoExecutor.version((String)deployPluginVersion)), (String)MojoExecutor.goal((String)"deploy-file"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"file"), (String)this.pomName.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"pomFile"), (String)this.pomName.getAbsolutePath()), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)this.artifactId), MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)this.groupId), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)this.mavenProject.getVersion()), MojoExecutor.element((String)MojoExecutor.name((String)"packaging"), (String)"pom"), MojoExecutor.element((String)MojoExecutor.name((String)"url"), (String)repo.getUrl()), MojoExecutor.element((String)MojoExecutor.name((String)"repositoryId"), (String)repo.getId())}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)tmpProject, (MavenSession)this.mavenSession, (BuildPluginManager)this.pluginManager));
        }
        finally {
            this.mavenSession.setCurrentProject(this.mavenProject);
        }
        this.getLog().debug((CharSequence)("Completed install/deploy for " + this.pomName + " to target location " + this.groupId + ':' + this.artifactId + ':' + this.mavenProject.getVersion()));
    }

    private ArtifactRepository getDeploymentRepository(MavenProject project, String altDeploymentRepository, String altSnapshotDeploymentRepository) throws MojoExecutionException, MojoFailureException {
        ArtifactRepository repo = null;
        String altDeploymentRepo = ArtifactUtils.isSnapshot((String)project.getVersion()) && altSnapshotDeploymentRepository != null ? altSnapshotDeploymentRepository : altDeploymentRepository;
        if (altDeploymentRepo != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + altDeploymentRepo));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(altDeploymentRepo);
            if (!matcher.matches()) {
                throw new MojoFailureException((Object)altDeploymentRepo, "Invalid syntax for repository.", "Invalid syntax for alternative repository. Use \"id::layout::url\".");
            }
            String id = matcher.group(1).trim();
            String layout = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            ArtifactRepositoryLayout repoLayout = this.getLayout(layout);
            repo = this.repositoryFactory.createDeploymentArtifactRepository(id, url, repoLayout, true);
        }
        if (repo == null) {
            repo = project.getDistributionManagementArtifactRepository();
        }
        if (repo == null) {
            String msg = "Deployment failed: repository element was not specified in the POM inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        return repo;
    }

    private ArtifactRepositoryLayout getLayout(String id) throws MojoExecutionException {
        ArtifactRepositoryLayout layout = this.repositoryLayouts.get(id);
        if (layout == null) {
            throw new MojoExecutionException("Invalid repository layout: " + id);
        }
        return layout;
    }
}

