/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import gorsat.Regression.LinearAlgebra;
import gorsat.Regression.LogisticRegression;
import java.util.Arrays;

class MultipleCovariateLogisticRegression
extends LogisticRegression {
    MultipleCovariateLogisticRegression(int numberOfDepVars, int maximumNumberOfSamples) {
        super(numberOfDepVars, maximumNumberOfSamples);
    }

    @Override
    protected void computeTestStats() {
        double[] x = this.zStats;
        double[] y = this.pValues;
        for (int k = this.dim - 1; k != -1; --k) {
            int i;
            double[] u = this.hessian[k];
            double z = y[k] = 1.0 / u[k];
            for (i = k - 1; i != -1; --i) {
                y[i] = -u[i] * z;
            }
            for (int j = k - 1; j != -1; --j) {
                u = this.hessian[j];
                int n = j;
                double d = y[n] / u[j];
                y[n] = d;
                z = d;
                for (int i2 = j - 1; i2 != -1; --i2) {
                    int n2 = i2;
                    y[n2] = y[n2] - u[i2] * z;
                }
            }
            for (i = 0; i <= k; ++i) {
                u = this.hessian[i];
                z = y[i];
                for (int j = 0; j < i; ++j) {
                    z -= u[j] * x[j];
                }
                x[i] = z / u[i];
            }
            this.zStats[k] = this.beta[k] / Math.sqrt(x[k]);
        }
    }

    @Override
    protected void updateGradientAndHessian(double[][] x, boolean[] y) {
        Arrays.fill(this.oneOver, this.beta[0]);
        for (int i = 0; i < this.numberOfDepVars; ++i) {
            double[] xi = x[i];
            double tmp = this.beta[i + 1];
            for (int j = 0; j < this.numberOfSamples; ++j) {
                int n = j;
                this.oneOver[n] = this.oneOver[n] + tmp * xi[j];
            }
        }
        for (int j = 0; j < this.numberOfSamples; ++j) {
            double tmp1 = this.sf.sigmoid(this.oneOver[j]);
            double tmp2 = 1.0 - tmp1;
            this.oneOver[j] = tmp1;
            this.prod[j] = tmp2 * this.oneOver[j];
            this.gradMult[j] = y[j] ? tmp2 : -tmp1;
        }
        this.gradient[0] = LinearAlgebra.sum(this.gradMult, this.numberOfSamples);
        for (int i = 1; i < this.dim; ++i) {
            this.gradient[i] = LinearAlgebra.dotProd(this.gradMult, x[i - 1], this.numberOfSamples);
        }
        this.hessian[0][0] = LinearAlgebra.sum(this.prod, this.numberOfSamples);
        for (int i = 1; i < this.dim; ++i) {
            double[] hess_i = this.hessian[i];
            hess_i[0] = LinearAlgebra.dotProd(x[i - 1], this.prod, this.numberOfSamples);
            for (int j = 1; j <= i; ++j) {
                hess_i[j] = LinearAlgebra.tripleDotProd(x[i - 1], x[j - 1], this.prod, this.numberOfSamples);
            }
        }
    }

    @Override
    protected void updateGradientAndHessianFirstRun(double[][] x, boolean[] y) {
        for (int j = 0; j < this.numberOfSamples; ++j) {
            this.gradMult[j] = y[j] ? 0.5 : -0.5;
        }
        this.gradient[0] = LinearAlgebra.sum(this.gradMult, this.numberOfSamples);
        for (int i = 1; i < this.dim; ++i) {
            this.gradient[i] = LinearAlgebra.dotProd(this.gradMult, x[i - 1], this.numberOfSamples);
        }
        this.hessian[0][0] = (double)this.numberOfSamples * 0.25;
        for (int i = 1; i < this.dim; ++i) {
            double[] hess_i = this.hessian[i];
            double[] x_i = x[i - 1];
            hess_i[0] = LinearAlgebra.sum(x_i, this.numberOfSamples) * 0.25;
            for (int j = 1; j <= i; ++j) {
                hess_i[j] = LinearAlgebra.dotProd(x_i, x[j - 1], this.numberOfSamples) * 0.25;
            }
        }
    }
}

