/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Commands.CommandParseUtilities;
import gorsat.Commands.GenomicRange;
import gorsat.DynIterator;
import gorsat.process.ProcessSource;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.driver.providers.stream.datatypes.bam.BamIterator;
import org.gorpipe.gor.model.ChrDataScheme;
import org.gorpipe.gor.model.ChromoCache;
import org.gorpipe.gor.model.ContigDataScheme;
import org.gorpipe.gor.model.GenomicIterator;
import org.gorpipe.gor.model.Line;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.model.VcfGzGenomicIterator;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.model.gor.Pipes;
import org.gorpipe.model.gor.RowObj;

public class ProcessRowSource
extends ProcessSource {
    private final StringBuilder errorStr = new StringBuilder();
    List<String> commands;
    private GenomicIterator it;
    boolean nor;
    private ProcessBuilder pb;
    private Process p;
    private Path fileroot = null;
    private final String filter;

    public ProcessRowSource(String cmd, String type, boolean nor, GorSession session, GenomicRange.Range range, String filter) {
        this(CommandParseUtilities.quoteSafeSplit((String)cmd, (char)' '), type, nor, session, range, filter, Pipes.rowsToProcessBuffer());
    }

    public ProcessRowSource(String cmd, String type, boolean nor, GorSession session, GenomicRange.Range range, String filter, int bs) {
        this(CommandParseUtilities.quoteSafeSplit((String)cmd, (char)' '), type, nor, session, range, filter, bs);
    }

    public static String checkNested(String cmd, GorSession session, StringBuilder errorStr) {
        String ncmd;
        if (cmd.startsWith("<(")) {
            String tmpdir = System.getProperty("java.io.tmpdir");
            if (tmpdir == null || tmpdir.length() == 0) {
                tmpdir = "/tmp";
            }
            Path tmpath = Paths.get(tmpdir, new String[0]);
            String scmd = cmd.substring(2, cmd.length() - 1);
            Path fifopath = tmpath.resolve(Integer.toString(Math.abs(scmd.hashCode())));
            String pipename = fifopath.toAbsolutePath().toString();
            try {
                if (!Files.exists(fifopath, new LinkOption[0])) {
                    ProcessBuilder mkfifo = new ProcessBuilder("mkfifo", pipename);
                    Process p = mkfifo.start();
                    p.waitFor();
                }
                Thread t = new Thread(() -> {
                    try (OutputStream os = Files.newOutputStream(fifopath, new OpenOption[0]);
                         DynIterator.DynamicRowSource drs = new DynIterator.DynamicRowSource(scmd, session.getGorContext(), false);){
                        os.write(drs.getHeader().getBytes());
                        os.write(10);
                        while (drs.hasNext()) {
                            String rowstr = drs.next().toString();
                            os.write(rowstr.getBytes());
                            os.write(10);
                        }
                    }
                    catch (IOException e) {
                        errorStr.append(e.getMessage());
                    }
                    finally {
                        try {
                            Files.delete(fifopath);
                        }
                        catch (IOException iOException) {}
                    }
                });
                t.start();
            }
            catch (IOException | InterruptedException e) {
                throw new GorSystemException("Failed starting fifo thread", (Throwable)e);
            }
            ncmd = pipename;
        } else {
            boolean quotas = cmd.startsWith("'") || cmd.startsWith("\"");
            String string = ncmd = quotas ? cmd.substring(1, cmd.length() - 1) : cmd;
            if (quotas) {
                ncmd = ncmd.replace("\\t", "\t").replace("\\n", "\n");
            }
        }
        return ncmd;
    }

    private ProcessRowSource(String[] cmds, String type, boolean nor, GorSession session, GenomicRange.Range range, String fltr, int bs) {
        Object root;
        this.nor = nor;
        this.setBufferSize(bs);
        this.filter = fltr;
        this.commands = new ArrayList<String>();
        if (session != null && (root = session.getProjectContext().getRoot()) != null && ((String)root).length() > 0) {
            int i = ((String)root).indexOf(32);
            if (i == -1) {
                i = ((String)root).length();
            }
            this.fileroot = Paths.get(((String)root).substring(0, i), new String[0]);
        }
        for (String cmd : cmds) {
            String ncmd = ProcessRowSource.checkNested(cmd, session, this.errorStr);
            this.commands.add(ncmd);
        }
        boolean bamvcf = type != null && (type.equals("bam") || type.equals("sam") || type.equals("cram") || type.equals("vcf"));
        List<String> headercommands = bamvcf ? ProcessRowSource.seekCmd(this.commands, this.it, null, 0, -1, null) : ProcessRowSource.seekCmd(this.commands, this.it, range.chromosome(), range.start(), range.stop(), this.filter);
        try {
            List<String> rcmd = headercommands.stream().filter(p -> p.length() > 0).collect(Collectors.toList());
            this.pb = new ProcessBuilder(rcmd);
            if (this.fileroot != null) {
                this.pb.directory(this.fileroot.toFile());
            }
            this.p = this.pb.start();
            Thread errorThread = new Thread(() -> {
                try {
                    InputStream es = this.p.getErrorStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(es));
                    String line = br.readLine();
                    while (line != null) {
                        this.errorStr.append(line).append("\n");
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            errorThread.start();
            InputStream is = this.p.getInputStream();
            if (type == null || type.equalsIgnoreCase("gor")) {
                this.it = this.gorIterator(is, headercommands, type);
            } else if (type.equalsIgnoreCase("vcf")) {
                this.it = this.vcfIterator(is);
                if (range.chromosome() != null) {
                    this.it.seek(range.chromosome(), range.start(), range.stop());
                }
            } else if (type.equalsIgnoreCase("bam") || type.equalsIgnoreCase("sam") || type.equalsIgnoreCase("cram")) {
                this.it = this.bamIterator(is);
            }
            if (range.chromosome() != null) {
                this.it.seek(range.chromosome(), range.start(), range.stop());
            }
            String header = this.it.getHeader();
            String[] headerArray = header.split("\t");
            this.it.setColnum(headerArray.length - 2);
            this.setHeader(String.join((CharSequence)"\t", header));
        }
        catch (IOException e) {
            throw new GorResourceException("unable to get header from process " + this.commands.get(0), "", (Throwable)e);
        }
    }

    private GenomicIterator gorIterator(InputStream is, List<String> headercommands, final String type) throws IOException {
        final BufferedReader br = new BufferedReader(new InputStreamReader(is));
        final String header = br.readLine();
        this.setHeader(header);
        if (this.getHeader() == null) {
            throw new GorSystemException("Running external process: " + String.join((CharSequence)" ", headercommands) + " with error: " + this.errorStr, null);
        }
        if (this.nor) {
            this.setHeader("ChromNOR\tPosNOR\t" + this.getHeader().replace(" ", "_").replace(":", ""));
        }
        return new GenomicIterator(){
            BufferedReader reader;
            String next;
            {
                this.reader = br;
                this.next = this.readLine();
            }

            private String readLine() throws IOException {
                String line = this.reader.readLine();
                if (line == null) {
                    return null;
                }
                return ProcessRowSource.this.nor ? "chrN\t0\t" + line : line;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Row next() {
                Row row = RowObj.StoR((CharSequence)this.next);
                try {
                    this.next = this.readLine();
                }
                catch (IOException e) {
                    throw new GorSystemException("Error reading next line from external process", (Throwable)e);
                }
                return row;
            }

            public String getHeader() {
                return header;
            }

            public boolean seek(String seekChr, int seekPos) {
                InputStream is = ProcessRowSource.this.setRange(seekChr, seekPos, -1);
                this.reader = new BufferedReader(new InputStreamReader(is));
                try {
                    if (type != null) {
                        this.readLine();
                    }
                    this.next = this.readLine();
                }
                catch (IOException e) {
                    throw new GorSystemException("Error reading next line from external process after seek", (Throwable)e);
                }
                return true;
            }

            public boolean next(Line line) {
                return false;
            }

            public void close() {
                try {
                    this.reader.close();
                    ProcessRowSource.this.p.destroy();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    private GenomicIterator vcfIterator(InputStream is) {
        VcfGzGenomicIterator vcfit;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        final GenomicIterator.ChromoLookup lookup = ProcessRowSource.createChromoLookup();
        try {
            vcfit = new VcfGzGenomicIterator(lookup, "filename", null, br){

                public boolean seek(String seekChr, int seekPos) {
                    return this.seek(seekChr, seekPos, lookup.chrToLen(seekChr));
                }

                public boolean seek(String seekChr, int seekPos, int endPos) {
                    try {
                        this.reader.close();
                        if (seekChr != null && this.chrNameSystem != VcfGzGenomicIterator.ChrNameSystem.WITH_CHR_PREFIX) {
                            seekChr = seekChr.substring(3);
                        }
                        InputStream is1 = ProcessRowSource.this.setRange(seekChr, seekPos, endPos == 0 ? 1 : endPos);
                        this.reader = new BufferedReader(new InputStreamReader(is1));
                        this.next = this.reader.readLine();
                        while (this.next != null && this.next.startsWith("##")) {
                            this.next = this.reader.readLine();
                        }
                        while (this.next != null && !this.next.startsWith("#")) {
                            this.next = this.reader.readLine();
                        }
                        while (this.next != null && this.next.startsWith("#")) {
                            this.next = this.reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        throw new GorSystemException("Error reading next line from external process providing vcf stream", (Throwable)e);
                    }
                    return true;
                }

                public void close() {
                    super.close();
                }
            };
        }
        catch (Exception e) {
            this.p.destroy();
            int exitValue = 0;
            try {
                boolean didStop = this.p.waitFor(1L, TimeUnit.SECONDS);
                if (!didStop) {
                    this.p.destroyForcibly();
                    exitValue = this.p.waitFor();
                } else {
                    exitValue = this.p.exitValue();
                }
            }
            catch (InterruptedException ie) {
                this.errorStr.append(ie.getMessage());
            }
            throw new GorSystemException("Error initializing vcf reader. Exit value from process: " + exitValue + ". Error from process: " + this.errorStr, (Throwable)e);
        }
        return vcfit;
    }

    private GenomicIterator bamIterator(InputStream is) {
        final GenomicIterator.ChromoLookup lookup = ProcessRowSource.createChromoLookup();
        final SamReaderFactory srf = SamReaderFactory.makeDefault().validationStringency(ValidationStringency.SILENT);
        SamInputResource sir = SamInputResource.of((InputStream)is);
        SamReader samreader = srf.open(sir);
        BamIterator bamit = new BamIterator(){

            public boolean seek(String chr, int pos) {
                return super.seek(chr, pos);
            }

            public boolean seek(String chr, int pos, int end) {
                int chrId = lookup.chrToId(chr);
                if (this.chrnamesystem == 1) {
                    chr = ChromoCache.getHgName((int)chrId);
                } else if (this.chrnamesystem == 2) {
                    chr = ChromoCache.getStdChrName((int)chrId);
                }
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                InputStream nis = ProcessRowSource.this.setRange(chr, pos, end);
                SamInputResource sir = SamInputResource.of((InputStream)nis);
                this.reader = srf.open(sir);
                this.pos = pos;
                return true;
            }

            public boolean hasNext() {
                this.initIterator();
                boolean hasNext = this.it.hasNext();
                while (hasNext && (this.record = (SAMRecord)this.it.next()) != null && (this.record.getReadUnmappedFlag() || "*".equals(this.record.getCigarString()) || this.record.getStart() < this.pos)) {
                    hasNext = this.it.hasNext();
                }
                if (!hasNext && this.hgSeekIndex >= 0) {
                    while (++this.hgSeekIndex < ChrDataScheme.ChrLexico.getOrder2id().length) {
                        String name = this.getChromName();
                        if (this.samFileHeader.getSequenceIndex(name) <= -1) continue;
                        this.createIterator(name, 0);
                        return this.hasNext();
                    }
                }
                return hasNext;
            }

            public void createIterator(String chr, int pos) {
                if (this.it == null) {
                    this.it = this.reader.iterator();
                }
            }
        };
        bamit.init(lookup, samreader, null, false);
        bamit.chrnamesystem = 0;
        return bamit;
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public Row next() {
        return this.it.next();
    }

    private static void noSeekReplace(String cmd, List<String> seekcmd) {
        int sPos;
        int hPos = cmd.indexOf("#(H:");
        if (hPos != -1) {
            int hEnd = cmd.indexOf(41, hPos + 1);
            cmd = cmd.substring(0, hPos) + cmd.substring(hPos + 4, hEnd) + cmd.substring(hEnd + 1);
        }
        if ((sPos = cmd.indexOf("#(S:")) != -1) {
            int sEnd = cmd.indexOf(41, sPos + 1);
            cmd = cmd.substring(0, sPos) + cmd.substring(sEnd + 1);
        }
        if (sPos != -1 || hPos != -1) {
            seekcmd.addAll(Arrays.asList(cmd.split("[ ]+")));
        } else {
            seekcmd.add(cmd);
        }
    }

    private static String posReplace(String seek, GenomicIterator it, String seekChr, int startPos, int endPos) {
        seek = seekChr.startsWith("chr") ? seek.replace("chn", seekChr.substring(3)) : seek.replace("chn", seekChr);
        int pos = seek.indexOf("pos-end");
        if (pos != -1) {
            if (endPos == -1) {
                int len = Integer.MAX_VALUE;
                if (it != null && it.getLookup() != null) {
                    it.getLookup().chrToLen(seekChr);
                }
                seek = seek.replace("pos", startPos + 1 + "").replace("end", len + "");
            } else {
                seek = seek.replace("pos", startPos + 1 + "").replace("end", endPos + "");
            }
        } else if (seek.contains("pos")) {
            pos = seek.indexOf("pos-");
            seek = endPos == -1 ? seek.replace("pos", startPos + "") : (startPos == endPos && pos != -1 ? seek.replace("pos-", startPos + "") : seek.replace("pos", startPos + "").replace("end", endPos + ""));
        }
        return seek;
    }

    private static void seekReplace(String cmd, List<String> seekcmd, GenomicIterator it, String seekChr, int startPos, int endPos) {
        int sPos;
        int hPos = cmd.indexOf("#(H:");
        if (hPos != -1) {
            int hEnd = cmd.indexOf(41, hPos + 1);
            cmd = cmd.substring(0, hPos) + cmd.substring(hEnd + 1);
        }
        if ((sPos = cmd.indexOf("#(S:")) != -1) {
            int sEnd = cmd.indexOf(41, sPos + 1);
            String seek = cmd.substring(sPos + 4, sEnd).replace("chr", seekChr);
            seek = ProcessRowSource.posReplace(seek, it, seekChr, startPos, endPos);
            cmd = cmd.substring(0, sPos) + seek + cmd.substring(sEnd + 1);
        }
        if (sPos != -1 || hPos != -1) {
            seekcmd.addAll(Arrays.asList(cmd.split("[ ]+")));
        } else {
            seekcmd.add(cmd);
        }
    }

    public static String filterCmd(String[] commands, String filter) {
        CharSequence[] ret = ProcessRowSource.filterCmd(Arrays.asList(commands), filter).toArray(new String[0]);
        return String.join((CharSequence)" ", ret).trim();
    }

    private static List<String> filterCmd(List<String> commands, String filter) {
        ArrayList<String> seekcmd = new ArrayList<String>();
        for (String cmd : commands) {
            int fEnd;
            int fPos;
            if (filter == null) {
                fPos = cmd.indexOf("#(F:");
                if (fPos != -1) {
                    fEnd = CommandParseUtilities.quoteSafeIndexOf((String)cmd, (String)")", (boolean)true, (int)(fPos + 1));
                    if (fEnd == -1) {
                        fEnd = cmd.length();
                    }
                    cmd = cmd.substring(0, fPos) + cmd.substring(Math.min(cmd.length(), fEnd + 1));
                }
            } else {
                fPos = cmd.indexOf("#(F:");
                if (fPos != -1) {
                    fEnd = CommandParseUtilities.quoteSafeIndexOf((String)cmd, (String)")", (boolean)true, (int)(fPos + 1));
                    if (fEnd == -1) {
                        fEnd = cmd.length() - 1;
                    }
                    String filt = cmd.substring(fPos + 4, fEnd).replace("filter", filter);
                    cmd = cmd.substring(0, fPos) + filt + cmd.substring(fEnd + 1);
                }
            }
            if (cmd.length() <= 0) continue;
            seekcmd.add(cmd);
        }
        return seekcmd;
    }

    static List<String> seekCmd(List<String> commands, GenomicIterator it, String seekChr, int startPos, int endPos, String filter) {
        List<String> filtercmd = ProcessRowSource.filterCmd(commands, filter);
        ArrayList<String> seekcmd = new ArrayList<String>();
        for (String cmd : filtercmd) {
            if (seekChr == null) {
                ProcessRowSource.noSeekReplace(cmd, seekcmd);
                continue;
            }
            ProcessRowSource.seekReplace(cmd, seekcmd, it, seekChr, startPos, endPos);
        }
        return seekcmd;
    }

    @Override
    public InputStream setRange(String seekChr, int startPos, int endPos) {
        try {
            List<String> seekcmd = ProcessRowSource.seekCmd(this.commands, this.it, seekChr, startPos, endPos, this.filter);
            if (this.it != null) {
                this.it.close();
            }
            if (this.p != null && this.p.isAlive()) {
                this.p.destroy();
            }
            List<String> cmdlist = seekcmd.stream().filter(p -> p.length() > 0).collect(Collectors.toList());
            this.pb = new ProcessBuilder(cmdlist);
            if (this.fileroot != null) {
                this.pb.directory(this.fileroot.toFile());
            }
            this.p = this.pb.start();
            Thread errorThread = new Thread(() -> {
                try {
                    InputStream es = this.p.getErrorStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(es));
                    String line = br.readLine();
                    while (line != null) {
                        this.errorStr.append(line).append("\n");
                        line = br.readLine();
                    }
                    br.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            errorThread.start();
            return this.p.getInputStream();
        }
        catch (IOException e) {
            throw new GorSystemException("Unable to read line from external process in seek: " + this.commands, (Throwable)e);
        }
    }

    public void setPosition(String seekChr, int seekPos) {
        this.it.seek(seekChr, seekPos);
    }

    public void close() {
        if (this.it != null) {
            this.it.close();
        }
        if (this.p != null && this.p.isAlive()) {
            this.p.destroy();
        }
    }

    public boolean isBuffered() {
        return true;
    }

    public static GenomicIterator.ChromoLookup createChromoLookup() {
        final ChromoCache lookupCache = new ChromoCache();
        boolean addAnyChrToCache = true;
        final ChrDataScheme dataOutputScheme = ChrDataScheme.ChrLexico;
        return new GenomicIterator.ChromoLookup(){

            public final String idToName(int id) {
                return lookupCache.toName((ContigDataScheme)dataOutputScheme, id);
            }

            public final int chrToId(String chr) {
                return lookupCache.toIdOrUnknown((CharSequence)chr, true);
            }

            public final int chrToLen(String chr) {
                return lookupCache.toLen(chr);
            }

            public final int chrToId(CharSequence str, int strlen) {
                return lookupCache.toIdOrUnknown(str, strlen, true);
            }

            public final int prefixedChrToId(byte[] buf, int offset) {
                return lookupCache.prefixedChrToIdOrUnknown(buf, offset, true);
            }

            public final int prefixedChrToId(byte[] buf, int offset, int buflen) {
                return lookupCache.prefixedChrToIdOrUnknown(buf, offset, buflen, true);
            }

            public ChromoCache getChromCache() {
                return lookupCache;
            }
        };
    }
}

