/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.aeonbits.owner.Config;
import org.gorpipe.base.config.annotations.Documentation;
import org.gorpipe.gor.cli.Table;
import org.reflections.Reflections;

public class GorConfigDoc {
    public static void main(String[] args) {
        Reflections reflections = new Reflections(new Object[]{"com.nextcode", "com.decode", "org.gorpipe"});
        Set configs = reflections.getSubTypesOf(Config.class);
        for (Class config : configs) {
            if (!config.isInterface()) continue;
            LinkedList methods = Lists.newLinkedList(Arrays.asList(config.getDeclaredMethods()));
            methods.removeIf(m -> m.getAnnotation(Config.Key.class) == null);
            if (methods.isEmpty()) {
                System.err.println(String.format("Class %s is a Config interface but doesn't have any @Key annotations.", config.getName()));
                continue;
            }
            String name = config.getSimpleName().length() > 0 ? config.getSimpleName() : config.getName();
            Table table = new Table("### " + name);
            methods.sort((m1, m2) -> {
                Config.Key k1 = m1.getAnnotation(Config.Key.class);
                Config.Key k2 = m2.getAnnotation(Config.Key.class);
                return k1.value().compareTo(k2.value());
            });
            table.addHeader("key", "default value", "description");
            for (Method method : methods) {
                Config.Key key = method.getAnnotation(Config.Key.class);
                Config.DefaultValue defaultValue = method.getAnnotation(Config.DefaultValue.class);
                Documentation documentation = method.getAnnotation(Documentation.class);
                table.addRow(key == null ? "" : key.value(), defaultValue == null ? "" : defaultValue.value(), documentation == null ? "" : documentation.value());
            }
            System.out.println(table.toString());
        }
    }
}

