/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.cache;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.gorpipe.gor.cli.cache.AnalysisResult;
import org.gorpipe.gor.cli.cache.FilterOptions;
import org.gorpipe.gor.driver.meta.DataType;
import picocli.CommandLine;

@CommandLine.Command(name="purge", aliases={"p"}, description={"Purge cache based on age of cached files."})
public class PurgeCommand
extends FilterOptions
implements Runnable {
    @CommandLine.Option(names={"-y", "--nopropmpt"}, description={"No verification showed before deleting files"})
    private boolean noVerification;
    @CommandLine.Parameters(index="1", arity="0..1", defaultValue="10", paramLabel="AgeOfFile", description={"The age of files to keep in the cache. Age can is defined in number of days, defaults to 10 days."})
    private int ageInDays;
    private int fileCounter;
    private AnalysisResult result;
    private long ageTimeCutoff;

    @Override
    public void run() {
        if (!this.cachePath.exists() || !this.cachePath.isDirectory()) {
            System.err.printf("Cache path %1$s does not exist!", this.cachePath.toString());
            System.exit(-1);
        }
        this.analyseCache(this.cachePath, this.ageInDays);
        this.displayResult();
        this.verifyAndDeleteFromCache();
    }

    private void analyseCache(File cachePath, int age) {
        this.result = new AnalysisResult(this.cachePath.toPath());
        this.fileCounter = 0;
        this.ageTimeCutoff = System.currentTimeMillis() - Duration.ofDays(age).toMillis();
        this.listFiles(cachePath);
    }

    private void listFiles(File parentFile) {
        File[] fileArray = parentFile.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isFile()) {
                DataType type;
                long lastAccessTime = -1L;
                try {
                    BasicFileAttributes attrs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    FileTime time = attrs.lastAccessTime();
                    lastAccessTime = time.toMillis();
                }
                catch (Exception e) {
                    System.err.println("!!Failed to get last access time for: " + file.toString());
                }
                ++this.fileCounter;
                if (lastAccessTime > 0L && lastAccessTime < this.ageTimeCutoff && (type = DataType.fromFileName((String)file.getName())) != null) {
                    this.result.process(file.toPath());
                }
                System.err.print("Processing files: " + this.fileCounter + "\r");
                continue;
            }
            if (!file.isDirectory()) continue;
            this.listFiles(file);
        }
    }

    private void verifyAndDeleteFromCache() {
        if (this.result.getFileList().size() == 0) {
            System.err.println("No files to remove. Exiting.");
            System.exit(0);
        }
        if (!this.noVerification) {
            String answer;
            Scanner user_input = new Scanner(System.in);
            System.err.print("Remove files from cache? [y/n]:");
            while (!(answer = user_input.next().trim().toLowerCase()).equals("y")) {
                if (!answer.equals("n")) continue;
                System.exit(0);
            }
            System.err.println();
        }
        System.err.println("Removing files from cache at " + this.cachePath);
        List<String> fileNames = this.result.getFileList();
        int fileRemovalCounter = 0;
        String extra = this.dryRun ? " (dryrun)" : "";
        for (String filename : fileNames) {
            File fileToDelete = new File(this.cachePath, filename);
            if (this.verbose) {
                System.err.println("Removing: " + filename + extra);
            }
            if (!this.dryRun) {
                try {
                    if (!fileToDelete.delete()) {
                        System.err.println("Failed to delete file: " + filename);
                    }
                    ++fileRemovalCounter;
                }
                catch (Exception e) {
                    System.err.println("An error occurred when deleting file: " + filename);
                    System.err.println(e.getMessage());
                }
                continue;
            }
            ++fileRemovalCounter;
        }
        System.err.printf("Removed %1$d from cache%2$s%n", fileRemovalCounter, extra);
    }

    private void displayResult() {
        System.err.println("Processed files: " + this.fileCounter + "       ");
        System.err.println("Files to remove: " + this.result.getFileList().size());
        if (this.result.getFileList().size() > 0) {
            System.err.println("Summary by extension:");
            Map<String, Integer> extensionMap = this.result.getExtensionCountMap();
            for (Map.Entry<String, Integer> entry : extensionMap.entrySet()) {
                System.err.printf("\t%1$s\t%2$d%n", entry.getKey(), entry.getValue());
            }
            System.err.println();
        }
    }
}

