/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.help;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gorpipe.gor.cli.HelpOptions;
import picocli.CommandLine;

@CommandLine.Command(name="help", aliases={"h"}, description={"Gives help on gor commands and functions."}, header={"Gives help on gor commands and functions."})
public class HelpCommand
extends HelpOptions
implements Runnable {
    @CommandLine.Option(names={"-f", "--helpfile"}, description={"File containing the help text for all commands and functions."})
    private File helpFile;
    @CommandLine.Parameters(defaultValue="COMMANDS", index="0", arity="1", paramLabel="command", description={"View help for the selected command or function."})
    private String command;

    @Override
    public void run() {
        StringBuilder message = new StringBuilder();
        boolean toPrint = false;
        try {
            List<String> helpList = this.loadHelpList(this.helpFile);
            String helpCommandUpperCase = this.command.toUpperCase();
            for (String helpLine : helpList) {
                if (helpLine.startsWith("->")) {
                    if (helpLine.substring(2).toUpperCase().startsWith(helpCommandUpperCase)) {
                        toPrint = true;
                        message.append("\n").append(helpLine.substring(2)).append("\n").append("=====================", 2, helpLine.length()).append("\n\n");
                        continue;
                    }
                    toPrint = false;
                    continue;
                }
                if (!toPrint) continue;
                message.append(helpLine).append("\n");
            }
        }
        catch (Exception e) {
            message.append("Failed to load help for command ").append(this.command);
        }
        System.out.println(message);
    }

    private List<String> loadHelpList(File helpFile) throws IOException, URISyntaxException {
        List helpList = helpFile != null ? FileUtils.readLines((File)helpFile, (Charset)Charset.defaultCharset()) : this.loadHelpFiles();
        return helpList;
    }

    private List<String> loadHelpFiles() throws IOException, URISyntaxException {
        String[] helpFiles;
        ArrayList<String> helpList = new ArrayList<String>();
        for (String helpFileEntry : helpFiles = new String[]{"gor_commands_help.txt", "gor_functions_help.txt"}) {
            URI helpJarURL = this.getClass().getClassLoader().getResource(helpFileEntry).toURI();
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            try (FileSystem fileSystem = FileSystems.newFileSystem(helpJarURL, env);){
                helpList.addAll(Files.readAllLines(Paths.get(helpJarURL), Charset.forName("ISO-8859-1")));
            }
        }
        return helpList;
    }
}

