/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.gorpipe.gor.cli.manager.ManagerOptions;
import org.gorpipe.gor.manager.TableManager;
import picocli.CommandLine;

@CommandLine.Command(name="delete_bucket", description={"Delete the given bucket."}, header={"Delete a bucket"})
public class DeleteBucketCommand
extends ManagerOptions
implements Runnable {
    @CommandLine.Parameters(index="1", arity="0..*", paramLabel="BUCKET", description={"Buckets to delete, absolute path or relative to the table dir.  Values are specified as comma separated list."})
    private final List<String> argsBuckets = new ArrayList<String>();

    @Override
    public void run() {
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        tm.deleteBuckets(this.dictionaryFile.toPath(), (Path[])this.argsBuckets.stream().map(b -> Paths.get(b, new String[0])).toArray(Path[]::new));
    }
}

