/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.gorpipe.gor.cli.manager.FilterOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import picocli.CommandLine;

@CommandLine.Command(name="delete", aliases={"d"}, description={"Deletes matching entries."}, header={"Delete entries from a dictionary/table."})
public class DeleteCommand
extends FilterOptions
implements Runnable {
    @CommandLine.Parameters(index="1..*", arity="0..*", paramLabel="FILE", description={"List of files to delete, given as absolute path or relative to the table dir.  Values are specified as comma separated list.  Alternative to using -f."})
    private final List<String> inputFiles = new ArrayList<String>();

    @Override
    public void run() {
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        String[] allFiles = (String[])ArrayUtils.addAll((Object[])this.inputFiles.toArray(new String[0]), (Object[])this.files.toArray(new String[0]));
        String[] allTags = (String[])ArrayUtils.addAll((Object[])this.aliases.toArray(new String[0]), (Object[])this.tags.toArray(new String[0]));
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        tm.delete(this.dictionaryFile.toPath(), table.filter().files((String[])(allFiles.length > 0 ? allFiles : null)).tags((String[])(allTags.length > 0 ? allTags : null)).buckets(this.buckets.size() > 0 ? this.buckets.toArray(new String[0]) : null).chrRange(this.range).includeDeleted(this.includeDeleted));
    }
}

