/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.gorpipe.gor.cli.manager.CommandBucketizeOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import org.gorpipe.gor.table.GenomicRange;
import org.gorpipe.gor.table.PathUtils;
import org.gorpipe.gor.table.dictionary.DictionaryEntry;
import picocli.CommandLine;

@CommandLine.Command(name="insert", aliases={"i"}, description={"Inserts the given the gor files into the table.  All options apply to all the files."}, header={"Inserts gor files into a dictionary/table."})
public class InsertCommand
extends CommandBucketizeOptions
implements Runnable {
    @CommandLine.Parameters(index="1..*", arity="0..*", paramLabel="FILE", description={"Files to insert into dictionary/table."})
    List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"-t", "--tags"}, split=",", description={"Specify tags to use.  Values are specified as comma separated list."})
    private final List<String> tags = new ArrayList<String>();
    @CommandLine.Option(names={"-a", "--alias"}, description={"Aliases to use."})
    private String alias;
    @CommandLine.Option(names={"-r", "-p", "--range"}, description={"Specify range to use.  Value is specified as <chrom start>[:<poststart>][-[<chrom stop>:][<pos stop>]]."})
    private String range;
    @CommandLine.Option(names={"-s", "--source"}, description={"Column used for tag filtering. Defaults to 'PN'"})
    private final String source = "PN";
    @CommandLine.Option(names={"--tagskey"}, description={"All tags must be unique. The usage of the same tag twice is disallowed. If used on a dictionary with multiple files using the same tag this option will result in an error."})
    private boolean tagskey;

    @Override
    public void run() {
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        if ("PN" != null && !"PN".equals(table.getProperty("SOURCE_COLUMN"))) {
            table.setProperty("SOURCE_COLUMN", "PN");
        }
        if (this.alias != null && !this.tags.contains(this.alias)) {
            this.tags.add(this.alias);
        }
        if (this.tagskey) {
            table.setUniqueTags(this.tagskey);
        }
        tm.insert(this.dictionaryFile.toPath(), this.bucketPackLevel, this.workers, (BucketableTableEntry[])this.files.stream().map(f -> PathUtils.relativize((Path)table.getRootPath(), (Path)Paths.get(f, new String[0]))).map(p -> ((DictionaryEntry.Builder)((DictionaryEntry.Builder)new DictionaryEntry.Builder(p, table.getRootUri()).range(GenomicRange.parseGenomicRange((String)this.range))).tags(this.tags)).build()).toArray(DictionaryEntry[]::new));
    }
}

