/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.gorpipe.gor.cli.manager.CommandBucketizeOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import org.gorpipe.gor.table.GenomicRange;
import org.gorpipe.gor.table.PathUtils;
import org.gorpipe.gor.table.dictionary.DictionaryEntry;
import picocli.CommandLine;

@CommandLine.Command(name="multiinsert", aliases={"m"}, description={"Inserts multiple sets of gor files into the dictionary/table.  All options apply to all the file sets."}, header={"Inserts multiple gor files into a dictionary/table."})
public class MultiInsertCommand
extends CommandBucketizeOptions
implements Runnable {
    @CommandLine.Parameters(index="1..*", arity="0..*", paramLabel="FILE", description={"Files to insert, absolute path or relative to the table dir. Values are specified as comma separated list."})
    List<String> files = new ArrayList<String>();
    @CommandLine.Option(names={"-t", "--tags"}, split=",", description={"Specify tags to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed."})
    private List<String> tags = new ArrayList<String>();
    @CommandLine.Option(names={"-a", "--aliases"}, split=",", description={"Aliases to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed."})
    private List<String> aliases = new ArrayList<String>();
    @CommandLine.Option(names={"-r", "-p", "--ranges"}, split=",", description={"Specify range to use.  Values are specified as comma separated list, where length of the list must match the number of files and element i applies to the ith file.  Empty values are allowed.  Each values is specified as <chrom start>[:<poststart>][-[<chrom stop>:][<pos stop>]]."})
    private List<String> ranges = new ArrayList<String>();
    @CommandLine.Option(names={"-s", "--source"}, description={"Column used for tag filtering. Defaults to 'PN'"})
    private final String source = "PN";

    @Override
    public void run() {
        if (this.tags.size() != 0 && this.tags.size() != this.files.size()) {
            throw new IllegalArgumentException("Length of tag list must be the same as number of files (" + this.files.size() + ")");
        }
        if (this.aliases.size() != 0 && this.aliases.size() != this.files.size()) {
            throw new IllegalArgumentException("Length of alias list must be the same as number of files (" + this.files.size() + ")");
        }
        if (this.ranges.size() != 0 && this.ranges.size() != this.files.size()) {
            throw new IllegalArgumentException("Length of range list must be the same as number of files (" + this.files.size() + ")");
        }
        this.tags = this.tags.size() != 0 ? this.tags : Arrays.asList(new String[this.files.size()]);
        this.aliases = this.aliases.size() != 0 ? this.aliases : Arrays.asList(new String[this.files.size()]);
        this.ranges = this.ranges.size() != 0 ? this.ranges : Arrays.asList(new String[this.files.size()]);
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).minBucketSize(this.minBucketSize).bucketSize(this.bucketSize).lockTimeout(Duration.ofSeconds(this.lockTimeout)).build();
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        if ("PN" != null && !"PN".equals(table.getProperty("SOURCE_COLUMN"))) {
            table.setProperty("SOURCE_COLUMN", "PN");
        }
        tm.insert(this.dictionaryFile.toPath(), this.bucketPackLevel, this.workers, (BucketableTableEntry[])IntStream.range(0, this.files.size()).mapToObj(i -> ((DictionaryEntry.Builder)((DictionaryEntry.Builder)new DictionaryEntry.Builder(PathUtils.relativize((Path)table.getRootPath(), (Path)Paths.get(this.files.get(i), new String[0])), table.getRootUri()).range(GenomicRange.parseGenomicRange((String)this.ranges.get(i)))).alias(this.aliases.get(i)).tags(new String[]{this.tags.get(i)})).build()).toArray(DictionaryEntry[]::new));
    }
}

