/*
 * Decompiled with CFR 0.152.
 */
package gorsat.QueryHandlers;

import gorsat.Commands.CommandParseUtilities$;
import gorsat.Commands.Processor;
import gorsat.DynIterator;
import gorsat.Outputs.OutFile$;
import gorsat.Utilities.AnalysisUtilities$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.gorpipe.client.FileCache;
import org.gorpipe.gor.binsearch.GorIndexType;
import org.gorpipe.gor.session.GorContext;
import org.gorpipe.gor.session.GorRunner;
import org.gorpipe.model.gor.iterators.RowSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

public final class GeneralQueryHandler$ {
    public static GeneralQueryHandler$ MODULE$;
    private final Logger logger;

    static {
        new GeneralQueryHandler$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String findCacheFile(String commandSignature, String commandToExecute, boolean header, FileCache fileCache, String cacheDirectory) {
        return fileCache.tempLocation(commandSignature, CommandParseUtilities$.MODULE$.getExtensionForQuery(commandToExecute, header));
    }

    public String runCommand(GorContext context, String commandToExecute, String outfile, boolean useMd5) {
        context.start(outfile);
        String result = commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY_PART()) ? this.writeOutGorDictionaryPart(commandToExecute, outfile) : (commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY()) ? this.writeOutGorDictionary(commandToExecute, outfile) : (commandToExecute.toUpperCase().startsWith(CommandParseUtilities$.MODULE$.NOR_DICTIONARY()) ? this.writeOutNorDictionaryPart(commandToExecute, outfile) : this.runCommandInternal(context, commandToExecute, outfile, useMd5)));
        context.end();
        return result;
    }

    private String runCommandInternal(GorContext context, String commandToExecute, String outfile, boolean useMd5) {
        String string;
        DynIterator.DynamicRowSource theSource = new DynIterator.DynamicRowSource(commandToExecute, context, DynIterator.DynamicRowSource$.MODULE$.$lessinit$greater$default$3());
        String theHeader = theSource.getHeader();
        String temp_cacheFile = AnalysisUtilities$.MODULE$.getTempFileName(outfile);
        try {
            try {
                boolean nor = theSource.isNor();
                File oldName = null;
                File newName = null;
                if (useMd5) {
                    GorRunner runner = (GorRunner)context.getSession().getSystemContext().getRunnerFactory().create();
                    runner.run((RowSource)theSource, (Processor)OutFile$.MODULE$.apply(temp_cacheFile, theHeader, false, false, nor, useMd5, GorIndexType.NONE, OutFile$.MODULE$.apply$default$8(), OutFile$.MODULE$.apply$default$9()));
                    oldName = new File(temp_cacheFile);
                    Path md5File = Paths.get(new StringBuilder(4).append(temp_cacheFile).append(".md5").toString(), new String[0]);
                    if (Files.exists(md5File, new LinkOption[0])) {
                        java.util.List<String> md5SumLines = Files.readAllLines(md5File);
                        if (md5SumLines.size() > 0 && md5SumLines.get(0).length() > 0) {
                            String extension = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(outfile), new StringOps(Predef$.MODULE$.augmentString(outfile)).lastIndexOfSlice((GenSeq)Predef$.MODULE$.wrapString(".")), outfile.length());
                            newName = md5File.getParent().resolve(new StringBuilder(0).append(md5SumLines.get(0)).append(extension).toString()).toFile();
                        } else {
                            this.logger().warn("MD5 file names are enabled bu the md5 files are not returning any values.");
                        }
                    } else {
                        this.logger().warn("MD5 files are enabled but no md5 files are found when storing files in filecahce.");
                    }
                    if (newName == null) {
                        newName = new File(outfile);
                    }
                } else {
                    GorRunner runner = (GorRunner)context.getSession().getSystemContext().getRunnerFactory().create();
                    runner.run((RowSource)theSource, (Processor)OutFile$.MODULE$.apply(temp_cacheFile, theHeader, false, nor));
                    newName = new File(outfile);
                    oldName = new File(temp_cacheFile);
                }
                oldName.renameTo(newName);
                string = newName.toString();
            }
            catch (Exception e) {
                Object object;
                try {
                    object = BoxesRunTime.boxToBoolean((boolean)new File(temp_cacheFile).delete());
                }
                catch (Exception exception) {
                    object = BoxedUnit.UNIT;
                }
                throw e;
            }
        }
        finally {
            theSource.close();
        }
        return string;
    }

    private String writeOutGorDictionary(String commandToExecute, String outfile) {
        String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
        Nil$ dictFiles = Nil$.MODULE$;
        Nil$ chromsrange = Nil$.MODULE$;
        for (int i = 1; i < w.length - 1; i += 2) {
            dictFiles = dictFiles.$colon$colon((Object)this.getRelativeFileLocationForDictionaryFileReferences(w[i]));
            chromsrange = chromsrange.$colon$colon((Object)w[i + 1]);
        }
        IntRef chrI = IntRef.create((int)0);
        List dictList = (List)((List)dictFiles.zip((GenIterable)chromsrange, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            String[] stasto;
            String f = (String)x._1();
            String[] cep = new StringOps(Predef$.MODULE$.augmentString((String)x._2())).split(':');
            Tuple3 tuple3 = new Tuple3((Object)cep[0], (Object)(stasto = new StringOps(Predef$.MODULE$.augmentString(cep[1])).split('-'))[0], (Object)stasto[1]);
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String c = (String)tuple3._1();
            String sp2 = (String)tuple3._2();
            String ep = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)c, (Object)sp2, (Object)ep);
            Tuple3 tuple33 = tuple32;
            String c2 = (String)tuple33._1();
            String sp3 = (String)tuple33._2();
            String ep2 = (String)tuple33._3();
            ++chrI$1.elem;
            return new StringBuilder(5).append(f).append("\t").append(chrI$1.elem).append("\t").append(c2).append("\t").append(sp3).append("\t").append(c2).append("\t").append(ep2).toString();
        }, List$.MODULE$.canBuildFrom());
        AnalysisUtilities$.MODULE$.writeList(outfile, (List<String>)dictList);
        return outfile;
    }

    public String writeOutNorDictionaryPart(String commandToExecute, String outfile) {
        String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
        Nil$ dictFiles = Nil$.MODULE$;
        Nil$ partitions = Nil$.MODULE$;
        for (int i = 1; i < w.length - 1; i += 2) {
            dictFiles = dictFiles.$colon$colon((Object)this.getRelativeFileLocationForDictionaryFileReferences(w[i]));
            partitions = partitions.$colon$colon((Object)w[i + 1]);
        }
        List dictList = (List)((List)dictFiles.zip((GenIterable)partitions, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            String f = (String)x._1();
            String part = (String)x._2();
            return new StringBuilder(1).append(f).append("\t").append(part).toString();
        }, List$.MODULE$.canBuildFrom());
        AnalysisUtilities$.MODULE$.writeList(outfile, (List<String>)dictList);
        return outfile;
    }

    private String writeOutGorDictionaryPart(String commandToExecute, String outfile) {
        String[] w = new StringOps(Predef$.MODULE$.augmentString(commandToExecute)).split(' ');
        Nil$ dictFiles = Nil$.MODULE$;
        Nil$ partitions = Nil$.MODULE$;
        for (int i = 1; i < w.length - 1; i += 2) {
            dictFiles = dictFiles.$colon$colon((Object)this.getRelativeFileLocationForDictionaryFileReferences(w[i]));
            partitions = partitions.$colon$colon((Object)w[i + 1]);
        }
        List dictList = (List)((List)dictFiles.zip((GenIterable)partitions, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> {
            String f = (String)x._1();
            String part = (String)x._2();
            return new StringBuilder(1).append(f).append("\t").append(part).toString();
        }, List$.MODULE$.canBuildFrom());
        AnalysisUtilities$.MODULE$.writeList(outfile, (List<String>)dictList);
        return outfile;
    }

    public String getRelativeFileLocationForDictionaryFileReferences(String fileName) {
        return fileName.startsWith("/") ? fileName : new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("../")).$times(new StringOps(Predef$.MODULE$.augmentString(fileName)).count((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GeneralQueryHandler$.$anonfun$getRelativeFileLocationForDictionaryFileReferences$1(BoxesRunTime.unboxToChar((Object)x)))))).append(fileName).toString();
    }

    public long findOverheadTime(String commandToExecute) {
        int overheadTime;
        block1: {
            block0: {
                overheadTime = 0;
                if (!commandToExecute.startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY_PART())) break block0;
                overheadTime = 600000;
                break block1;
            }
            if (!commandToExecute.startsWith(CommandParseUtilities$.MODULE$.GOR_DICTIONARY())) break block1;
            overheadTime = 600000;
        }
        return overheadTime;
    }

    public static final /* synthetic */ boolean $anonfun$getRelativeFileLocationForDictionaryFileReferences$1(char x) {
        return x == '/';
    }

    private GeneralQueryHandler$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }
}

