/*
 * Decompiled with CFR 0.152.
 */
package gorsat.gtgen;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class PowerLookupTable {
    private final double[] powers;
    private final double x;
    private static final Map<Double, WeakReference<PowerLookupTable>> cache = new HashMap<Double, WeakReference<PowerLookupTable>>();

    private PowerLookupTable(double x, int n) {
        this.powers = new double[n];
        double y = 1.0;
        for (int i = 0; i < n; ++i) {
            this.powers[i] = y;
            y *= x;
        }
        this.x = x;
    }

    double pow(int e) {
        if (e < this.powers.length) {
            return this.powers[e];
        }
        return PowerLookupTable.pow(this.x, e);
    }

    public static double pow(double x, int e) {
        double mult;
        if (e == 0) {
            return 1.0;
        }
        double res = 1.0;
        if (e > 0) {
            mult = x;
        } else {
            mult = 1.0 / x;
            e = -e;
        }
        while (true) {
            if ((e & 1) == 1) {
                res *= mult;
            }
            if ((e >>>= 1) == 0) break;
            mult *= mult;
        }
        return res;
    }

    static synchronized PowerLookupTable getLookupTable(double x) {
        PowerLookupTable toReturn;
        PowerLookupTable candidate;
        WeakReference<PowerLookupTable> ref = cache.get(x);
        if (ref == null || (candidate = (PowerLookupTable)ref.get()) == null) {
            toReturn = new PowerLookupTable(x, 100);
            cache.put(x, new WeakReference<PowerLookupTable>(toReturn));
        } else {
            toReturn = candidate;
        }
        return toReturn;
    }
}

