/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.gorpipe.gor.model.Row;

public class GorParquetWriteSupport
extends WriteSupport<Row> {
    RecordConsumer currentRecordConsumer;
    List<Type> types;
    boolean ordered;
    boolean nor;
    String[] schemaSplit;

    public WriteSupport.WriteContext init(Configuration configuration) {
        int start;
        this.types = new ArrayList<Type>();
        this.ordered = configuration.getBoolean("ordered", false);
        this.nor = configuration.getBoolean("nor", false);
        String header = configuration.get("header");
        String schema = configuration.get("schema");
        String[] headerSplit = header.split("\t");
        this.schemaSplit = schema.split("\t");
        for (int i = start = this.nor ? 2 : 0; i < headerSplit.length; ++i) {
            String colName = headerSplit[i];
            String typeName = this.schemaSplit[i];
            if (typeName.equals("I")) {
                this.types.add((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (Type.Repetition)Type.Repetition.REQUIRED).named(colName));
                continue;
            }
            if (typeName.equals("D")) {
                this.types.add((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (Type.Repetition)Type.Repetition.REQUIRED).named(colName));
                continue;
            }
            if (typeName.equals("L")) {
                this.types.add((Type)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64, (Type.Repetition)Type.Repetition.REQUIRED).named(colName));
                continue;
            }
            this.types.add((Type)((Types.PrimitiveBuilder)Types.primitive((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (Type.Repetition)Type.Repetition.REQUIRED).as(OriginalType.UTF8)).named(colName));
        }
        if (this.nor) {
            this.schemaSplit = Arrays.copyOfRange(this.schemaSplit, 2, this.schemaSplit.length);
        }
        MessageType msgType = new MessageType(this.nor ? "nor" : "gor", this.types);
        HashMap meta = new HashMap();
        return new WriteSupport.WriteContext(msgType, meta);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.currentRecordConsumer = recordConsumer;
    }

    public void write(Row row) {
        this.currentRecordConsumer.startMessage();
        int start = 0;
        if (!this.nor) {
            this.currentRecordConsumer.startField(this.types.get(0).getName(), 0);
            Binary chr = Binary.fromCharSequence((CharSequence)row.chr);
            this.currentRecordConsumer.addBinary(chr);
            this.currentRecordConsumer.endField(this.types.get(0).getName(), 0);
            this.currentRecordConsumer.startField(this.types.get(1).getName(), 1);
            this.currentRecordConsumer.addInteger(row.pos);
            this.currentRecordConsumer.endField(this.types.get(1).getName(), 1);
            start = 2;
        }
        for (int i = start; i < this.types.size(); ++i) {
            this.currentRecordConsumer.startField(this.types.get(i).getName(), i);
            int offset = i + 2 - start;
            if (this.schemaSplit[i].equals("I")) {
                this.currentRecordConsumer.addInteger(row.colAsInt(offset));
            } else if (this.schemaSplit[i].equals("L")) {
                this.currentRecordConsumer.addLong(row.colAsLong(offset).longValue());
            } else if (this.schemaSplit[i].equals("D")) {
                this.currentRecordConsumer.addDouble(row.colAsDouble(offset));
            } else {
                Binary bin = Binary.fromCharSequence((CharSequence)row.colAsString(offset));
                this.currentRecordConsumer.addBinary(bin);
            }
            this.currentRecordConsumer.endField(this.types.get(i).getName(), i);
        }
        this.currentRecordConsumer.endMessage();
    }
}

