/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.query;

import ch.qos.logback.classic.Level;
import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.GorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.gorpipe.exceptions.ExceptionUtilities;
import org.gorpipe.exceptions.GorException;
import org.gorpipe.gor.cli.HelpOptions;
import org.gorpipe.gor.model.DbSource;
import org.gorpipe.gor.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="query", aliases={"q"}, description={"Execute a gor query, script or template"}, header={"Execute a gor query, script or template"})
public class QueryCommand
extends HelpOptions
implements Runnable {
    private static final Logger consoleLogger = LoggerFactory.getLogger((String)("console." + QueryCommand.class));
    @CommandLine.Option(defaultValue="false", names={"-t", "--stacktrace"}, description={"Displays stack trace for errors."})
    private boolean showStackTrace;
    @CommandLine.Option(defaultValue="false", names={"-s", "--scriptfile"}, description={"The input query is a script file."})
    private boolean inputIsScript;
    @CommandLine.Option(names={"-c", "--config"}, description={"Loads configuration from external file."})
    private File configFile;
    @CommandLine.Option(names={"-a", "--aliases"}, description={"Loads aliases from external file."})
    private File aliasFile;
    @CommandLine.Option(names={"-d", "--cachedir"}, description={"Path to cache directory for the current gor query."})
    private Path cacheDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    @CommandLine.Option(defaultValue="", names={"-p", "--projectroot"}, description={"Sets the project root for the current gor query."})
    private Path projectRoot;
    @CommandLine.Option(names={"-r", "--requestid"}, description={"Sets a request id for the current gor query, used to identify logs and errors."})
    private String requestId = UUID.randomUUID().toString();
    @CommandLine.Option(names={"-l", "--loglevel"}, defaultValue="warn", description={"Sets the log level to use for the current gor query. Available levels are none, debug, info, warn or error"})
    private String logLevel;
    @CommandLine.Option(defaultValue="0", names={"-w", "--workers"}, description={"Number of workers to execute the current gor query."})
    private int workers = 0;
    @CommandLine.Parameters(index="0", arity="1", paramLabel="InputQuery", description={"Queries to execute. Queries can be direct gor query, files containing gor script or gor report template."})
    private String query;

    @Override
    public void run() {
        this.setLogLevel();
        PipeOptions commandlineOptions = new PipeOptions();
        if (this.cacheDir != null) {
            commandlineOptions.cacheDir_$eq(this.cacheDir.toString());
        }
        if (this.aliasFile != null) {
            commandlineOptions.aliasFile_$eq(this.aliasFile.toString());
        }
        if (this.configFile != null) {
            commandlineOptions.configFile_$eq(this.configFile.toString());
        }
        if (this.projectRoot != null) {
            commandlineOptions.gorRoot_$eq(this.projectRoot.toString());
        }
        commandlineOptions.requestId_$eq(this.requestId);
        commandlineOptions.showStackTrace_$eq(this.showStackTrace);
        commandlineOptions.workers_$eq(this.workers);
        ExceptionUtilities.setShowStackTrace((Boolean)this.showStackTrace);
        int exitCode = 0;
        try {
            commandlineOptions.query_$eq(this.loadQuery(this.query, this.inputIsScript));
            ConfigUtil.loadConfig((String)"gor");
            DbSource.initInConsoleApp();
            CLIGorExecutionEngine executionEngine = new CLIGorExecutionEngine(commandlineOptions, null, null);
            ((GorExecutionEngine)executionEngine).execute();
        }
        catch (GorException ge) {
            consoleLogger.error(ExceptionUtilities.gorExceptionToString((Throwable)ge));
            exitCode = -1;
        }
        catch (Exception e) {
            consoleLogger.error("Unexpected error, please report if you see this.\n" + e.getMessage(), (Throwable)e);
            exitCode = -1;
        }
        System.exit(exitCode);
    }

    private void setLogLevel() {
        String logName = "ROOT";
        try {
            Level logLevel = Level.toLevel((String)this.logLevel, (Level)Level.WARN);
            Logger mainLogger = LoggerFactory.getLogger((String)logName);
            ((ch.qos.logback.classic.Logger)mainLogger).setLevel(logLevel);
        }
        catch (Exception e) {
            consoleLogger.warn("Failed to set {} log level to {}", (Object)logName, (Object)this.logLevel);
        }
    }

    private String loadQuery(String query, boolean inputIsScript) {
        String[] args = inputIsScript ? new String[]{"-script " + query} : new String[]{query};
        return PipeOptions.getQueryFromArgs(args);
    }
}

