/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.List;
import org.gorpipe.gorshell.Commands;
import picocli.CommandLine;

@CommandLine.Command(name="bash", description={"Run a bash command"})
public class BashCmd
implements Runnable {
    @CommandLine.ParentCommand
    private Commands parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Parameters
    List<String> params;

    @Override
    public void run() {
        if (this.params == null) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "bash expects some command");
        }
        String command = String.join((CharSequence)" ", this.params);
        BashCmd.runBashCommand(command, this.parent, this.spec);
    }

    static void runBashCommand(String command, Commands commandsInstance, CommandLine.Model.CommandSpec commandSpec) {
        Runtime r = Runtime.getRuntime();
        String[] commands = new String[]{"bash", "-c", command};
        try {
            File cwd = new File(System.getProperty("user.dir"));
            Process p = r.exec(commands, null, cwd);
            p.waitFor();
            BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = b.readLine()) != null) {
                commandsInstance.print(line);
            }
            b.close();
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(commandSpec.commandLine(), "Error", (Throwable)e);
        }
    }
}

