/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import org.gorpipe.gor.binsearch.PositionCache;
import org.gorpipe.gorshell.Commands;
import picocli.CommandLine;

@CommandLine.Command(name="pc", description={"PositionCache"}, subcommands={Info.class, Clear.class})
public class PositionCacheCmd
implements Runnable {
    @CommandLine.ParentCommand
    Commands parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void run() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="clear", description={"Clear the position cache"})
    static class Clear
    implements Runnable {
        @CommandLine.ParentCommand
        private PositionCacheCmd parent;

        Clear() {
        }

        @Override
        public void run() {
            PositionCache.clearGlobalCache();
            this.parent.parent.print("Position cache cleared");
        }
    }

    @CommandLine.Command(name="info", description={"Get information on the position cache"})
    static class Info
    implements Runnable {
        @CommandLine.ParentCommand
        PositionCacheCmd parent;

        Info() {
        }

        @Override
        public void run() {
            int files = PositionCache.getNumFilesInCache();
            int numKeys = PositionCache.getTotalNumKeysInCache();
            String msg = String.format("Position cache: %d files, %d keys", files, numKeys);
            this.parent.parent.print(msg);
        }
    }
}

