/*
 * Decompiled with CFR 0.152.
 */
package gorsat.process;

import gorsat.Iterators.NorInputSource;
import gorsat.process.NordIteratorEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gorpipe.exceptions.GorDataException;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.exceptions.GorResourceException;
import org.gorpipe.exceptions.GorSystemException;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.Row;
import org.gorpipe.gor.session.GorSession;
import org.gorpipe.gor.table.Dictionary;
import org.gorpipe.gor.util.StringUtil;
import org.gorpipe.model.gor.RowObj;
import org.gorpipe.model.gor.iterators.RowSource;

public class NordIterator
extends RowSource {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final boolean useFilter;
    private final Set<String> filterEntries;
    private final String nordFile;
    private String sourceColumnName;
    private String projectRoot = "";
    private FileReader fileReader;
    private final boolean ignoreMissingEntries;
    private final boolean forceReadOfHeader;
    private boolean addSourceColumn;
    private boolean showSourceColumn = true;
    private NorInputSource activeIterator;
    private Iterator<NordIteratorEntry> nordEntriesIterator;
    private NordIteratorEntry activeEntry = null;
    private int headerSize = 0;
    private String nordRoot;
    private static final String DEFAULT_SOURCE_COLUMN_NAME = "Source";
    private static final String SOURCE_PROPERTY_NAME = "Source";

    public NordIterator(String nordFile, boolean useFilter, String[] filterEntries, String sourceColumnName, boolean ignoreMissingEntries, boolean forceReadOfHeader) {
        this.nordFile = nordFile;
        this.useFilter = useFilter;
        this.filterEntries = new HashSet<String>(Arrays.asList(filterEntries));
        this.ignoreMissingEntries = ignoreMissingEntries;
        this.forceReadOfHeader = forceReadOfHeader;
        this.sourceColumnName = sourceColumnName;
    }

    public void close() {
        if (this.activeIterator != null) {
            this.activeIterator.close();
            this.activeIterator = null;
        }
    }

    public boolean hasNext() {
        while (this.activeIterator == null || !this.activeIterator.hasNext()) {
            if (this.prepareNextIterator()) continue;
            return false;
        }
        return this.activeIterator != null && this.activeIterator.hasNext();
    }

    public Row next() {
        if (this.activeIterator != null && this.activeIterator.hasNext()) {
            String extraColumn = "";
            if (this.showSourceColumn && this.addSourceColumn) {
                extraColumn = "\t" + this.activeEntry.getTag();
            }
            return RowObj.StoR((CharSequence)(this.activeIterator.next() + extraColumn));
        }
        return null;
    }

    public void setPosition(String seekChr, int seekPos) {
        throw new GorSystemException("Nor dictionary iterator does not support seek", null);
    }

    public void init(GorSession session) {
        this.fileReader = session.getProjectContext().getFileReader();
        this.projectRoot = session.getProjectContext().getRealProjectRoot();
        Path nordPath = Paths.get(this.nordFile, new String[0]);
        this.nordRoot = nordPath.getParent() == null ? "." : nordPath.getParent().toString();
        try (Stream nordStream = this.fileReader.iterateFile(this.nordFile, 0, false);){
            List<NordIteratorEntry> nordEntries = nordStream.peek(this::processProperty).filter(x -> !x.startsWith("#")).map(NordIteratorEntry::parse).filter(x -> !this.useFilter || this.filterEntries.contains(x.getTag())).collect(Collectors.toList());
            this.nordEntriesIterator = nordEntries.iterator();
            if (this.filterEntries.size() > 0 && !this.ignoreMissingEntries && nordEntries.size() < this.filterEntries.size()) {
                throw new GorParsingException("Missing entries in dictionary file: " + this.getMissingEntries(nordEntries));
            }
        }
        catch (IOException ioe) {
            throw new GorResourceException("Failed to open nor dictionary file: " + this.nordFile, this.nordFile, (Throwable)ioe);
        }
        if (StringUtil.isEmpty((Object)this.sourceColumnName)) {
            if (this.properties.containsKey("Source")) {
                this.sourceColumnName = this.properties.get("Source");
            } else {
                this.showSourceColumn = false;
                this.sourceColumnName = "Source";
            }
        }
        if (!this.nordEntriesIterator.hasNext()) {
            this.getHeaderFromFirstFile();
        }
        this.prepareNextIterator();
    }

    private void getHeaderFromFirstFile() {
        block14: {
            try (Stream stream = this.fileReader.iterateFile(this.nordFile, 0, false);){
                Optional<String> first = stream.filter(x -> !x.startsWith("#")).findFirst();
                if (!first.isPresent()) break block14;
                String fileName = NordIteratorEntry.parse(first.get()).getFilePath();
                Path entryPath = Paths.get(fileName, new String[0]);
                if (!entryPath.isAbsolute()) {
                    fileName = Paths.get(this.nordRoot, fileName).toString();
                }
                try (NorInputSource inputSource = new NorInputSource(fileName, this.fileReader, false, this.forceReadOfHeader, 0, false, false);){
                    this.getHeaderFromIterator(inputSource);
                }
            }
            catch (IOException e) {
                throw new GorResourceException("Failed to open nor dictionary file: " + this.nordFile, this.nordFile, (Throwable)e);
            }
        }
    }

    private void processProperty(String headerEntry) {
        if (StringUtil.isEmpty((Object)headerEntry) || !headerEntry.startsWith("##")) {
            return;
        }
        String[] entries = headerEntry.split("=");
        if (entries.length >= 2) {
            this.properties.put(entries[0].substring(2), headerEntry.substring(entries[0].length() + 1));
        }
    }

    private boolean prepareNextIterator() {
        this.close();
        if (this.nordEntriesIterator.hasNext()) {
            this.activeEntry = this.nordEntriesIterator.next();
            String fileName = this.activeEntry.getFilePath();
            Path entryPath = Paths.get(fileName, new String[0]);
            if (!entryPath.isAbsolute()) {
                Dictionary.FileReference reference = Dictionary.getDictionaryFileParent((Path)Paths.get(this.projectRoot, this.nordFile), (String)this.projectRoot);
                Dictionary.DictionaryLine line = Dictionary.parseDictionaryLine((String)this.activeEntry.toString(), (Dictionary.FileReference)reference, (String)this.nordFile);
                fileName = reference.logical != null ? line.fileRef.logical : Paths.get(this.nordRoot, fileName).toString();
            }
            this.activeIterator = new NorInputSource(fileName, this.fileReader, false, this.forceReadOfHeader, 0, false, false);
            try {
                this.getHeaderFromIterator(this.activeIterator);
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
            return true;
        }
        return false;
    }

    private void getHeaderFromIterator(NorInputSource inputSource) {
        String iteratorHeader = inputSource.getHeader();
        if (iteratorHeader.isEmpty()) {
            throw new GorDataException("Missing header for: " + this.activeEntry.getTag());
        }
        iteratorHeader = this.addOptionalSourceColumn(iteratorHeader);
        if (this.getHeader().isEmpty()) {
            this.setHeader(iteratorHeader);
            this.headerSize = iteratorHeader.split("\t").length;
        } else if (iteratorHeader.split("\t").length != this.headerSize) {
            throw new GorDataException("Header lengths do not match between dictionary files for: " + this.activeEntry.getTag());
        }
    }

    private String addOptionalSourceColumn(String iteratorHeader) {
        this.addSourceColumn = false;
        if (!iteratorHeader.contains("\t" + this.sourceColumnName)) {
            if (this.showSourceColumn) {
                iteratorHeader = iteratorHeader + "\t" + this.sourceColumnName;
            }
            this.addSourceColumn = true;
        }
        return iteratorHeader;
    }

    private String getMissingEntries(List<NordIteratorEntry> nordEntries) {
        HashSet<String> missingEntries = new HashSet<String>(this.filterEntries);
        missingEntries.removeAll(nordEntries.stream().map(NordIteratorEntry::getTag).collect(Collectors.toList()));
        return String.join((CharSequence)",", missingEntries);
    }
}

