/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.render;

import gorsat.Commands.CommandParseUtilities;
import gorsat.Utilities.AnalysisUtilities;
import gorsat.Utilities.MacroUtilities;
import gorsat.process.CLISessionFactory;
import gorsat.process.PipeOptions;
import java.util.Map;
import org.gorpipe.gor.cli.render.RenderOptions;
import org.gorpipe.gor.session.GorSession;
import picocli.CommandLine;

@CommandLine.Command(name="report", aliases={"r"}, header={"Renders gor report"}, description={"Renders yml report to its final executable form."})
public class ReportCommand
extends RenderOptions
implements Runnable {
    @Override
    public void run() {
        if (this.input.toUpperCase().contains(".YML")) {
            String[] stringArray;
            if (this.aliasFile != null) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = this.input;
                stringArray2[1] = "-alias";
                stringArray = stringArray2;
                stringArray2[2] = this.aliasFile.toString();
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = this.input;
            }
            PipeOptions options = PipeOptions.parseInputArguments(stringArray);
            CLISessionFactory sessionFactory = new CLISessionFactory(options, "");
            GorSession session = sessionFactory.create();
            String query = CommandParseUtilities.cleanupQuery((String)session.getSystemContext().getReportBuilder().parse(this.input));
            ReportCommand.renderQuery(session, query, this.pretty);
        } else {
            System.err.println("Input is not a yml report.");
        }
    }

    static void renderQuery(GorSession session, String query, boolean pretty) {
        CharSequence[] commands = CommandParseUtilities.quoteSafeSplitAndTrim((String)query, (char)';');
        Map<String, String> defines = MacroUtilities.extractAliases((String[])commands);
        commands = MacroUtilities.applyAliases((String[])commands, defines);
        String finalQuery = CommandParseUtilities.cleanupQueryWithFormat((String)String.join((CharSequence)";", commands));
        if (session.getProjectContext().getGorAliasFile() != null) {
            Map<String, String> aliases = AnalysisUtilities.loadAliases(session.getProjectContext().getGorAliasFile(), session, "gor_aliases.txt");
            finalQuery = MacroUtilities.replaceAllAliases(finalQuery, aliases);
        }
        System.out.println(pretty ? CommandParseUtilities.cleanupQueryWithFormat((String)finalQuery) : CommandParseUtilities.cleanupQuery((String)finalQuery));
    }
}

