/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.manager;

import gorsat.process.CLIGorExecutionEngine;
import gorsat.process.PipeOptions;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.gorpipe.gor.manager.BucketCreator;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.BucketableTableEntry;
import org.gorpipe.gor.table.PathUtils;
import org.gorpipe.gor.table.TableEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketCreatorGorPipe<T extends BucketableTableEntry>
implements BucketCreator<T> {
    private static final Logger log = LoggerFactory.getLogger(BucketCreatorGorPipe.class);
    public static final int DEFAULT_NUMBER_WORKERS = 4;
    private final int workers;

    public BucketCreatorGorPipe() {
        this(4);
    }

    public BucketCreatorGorPipe(int workers) {
        this.workers = workers;
    }

    @Override
    public void createBuckets(BaseTable<T> table, Map<Path, List<T>> bucketsToCreate, Path absBucketDir) throws IOException {
        Path workTempDir = this.createTempfoldersForCreateBucketFiles(table, bucketsToCreate.keySet(), absBucketDir);
        String gorPipeCommand = this.createBucketizeGorCommand(bucketsToCreate, workTempDir, table);
        Object[] args = new String[]{gorPipeCommand, "-cachedir", workTempDir.resolve("cache").toString(), "-workers", String.valueOf(this.workers)};
        log.trace("Calling bucketize with command args: {} \"{}\" {} {} {} {}", args);
        PrintStream oldOut = System.out;
        PipeOptions options = new PipeOptions();
        options.parseOptions((String[])args);
        CLIGorExecutionEngine engine = new CLIGorExecutionEngine(options, null, table.getSecurityContext());
        try (PrintStream newPrintStream = new PrintStream((OutputStream)new NullOutputStream());){
            System.setOut(newPrintStream);
            engine.execute();
        }
        catch (Exception e) {
            log.error("Calling bucketize failed.  Command args: {} \"{}\" {} {} {} {} failed", args);
            throw e;
        }
        finally {
            System.setOut(oldOut);
        }
        for (Path bucket : bucketsToCreate.keySet()) {
            Path targetBucketPath = PathUtils.resolve((Path)table.getRootPath(), (Path)bucket);
            Files.move(workTempDir.resolve(bucket), targetBucketPath, new CopyOption[0]);
        }
        BucketCreatorGorPipe.deleteIfTempBucketizingFolder(workTempDir, table);
    }

    private String createBucketizeGorCommand(Map<Path, List<T>> bucketsToCreate, Path tempRootDir, BaseTable<T> table) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Path, List<T>> b2c : bucketsToCreate.entrySet()) {
            Path bucket = b2c.getKey();
            String tags = b2c.getValue().stream().map(TableEntry::getAliasTag).distinct().collect(Collectors.joining(","));
            if (tags.length() <= 0) continue;
            sb.append(String.format("create #%s# = gor %s -s %s -f %s %s | write -c %s;%n", bucket, table.getPath(), table.getTagColumn(), tags, table.getSecurityContext() != null ? table.getSecurityContext() : "", tempRootDir.resolve(bucket.toString())));
        }
        sb.append("gor 1.mem| top 1\n");
        return sb.toString();
    }

    static void deleteIfTempBucketizingFolder(Path path, BaseTable<? extends BucketableTableEntry> table) throws IOException {
        if (path.getFileName().toString().startsWith(BucketCreatorGorPipe.getBucketizingFolderPrefix(table))) {
            log.debug("Deleting temp folder: {}", (Object)path);
            FileUtils.deleteDirectory((File)path.toFile());
        }
    }

    static String getBucketizingFolderPrefix(BaseTable<? extends BucketableTableEntry> table) {
        return "bucketizing_" + table.getId();
    }

    private Path createTempfoldersForCreateBucketFiles(BaseTable<T> table, Set<Path> buckets, Path workBaseDir) throws IOException {
        Path tempRootDir = Files.createDirectory(workBaseDir.resolve(BucketCreatorGorPipe.getBucketizingFolderPrefix(table)), new FileAttribute[0]);
        log.trace("Created temp folder {}", (Object)tempRootDir);
        tempRootDir.toFile().deleteOnExit();
        for (Path bucketDir : buckets.stream().map(Path::getParent).distinct().collect(Collectors.toList())) {
            Path bucketsRelativePath = bucketDir.isAbsolute() ? workBaseDir.relativize(bucketDir) : bucketDir;
            if (bucketsRelativePath.toString().length() <= 0) continue;
            Files.createDirectories(tempRootDir.resolve(bucketsRelativePath), new FileAttribute[0]);
        }
        Files.createDirectory(tempRootDir.resolve("cache"), new FileAttribute[0]);
        return tempRootDir;
    }
}

