/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.util.ArrayList;
import java.util.List;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;

public class FileArgument
extends Argument {
    private final List<String> fileFilterComponents;

    public FileArgument(ArgumentDescription argDescr, Boolean optional, Object defaultValue, Boolean advanced, Integer displayWidth, String filterFileSuffixes) {
        super(ArgumentType.FILE, argDescr, optional, defaultValue, null, null, null, advanced, displayWidth);
        this.fileFilterComponents = this.createFileFilterComponents(filterFileSuffixes);
    }

    public FileArgument(FileArgument arg) {
        super(arg);
        this.fileFilterComponents = this.copyFileFilterComponents(arg.fileFilterComponents);
    }

    @Override
    public FileArgument copyArgument() {
        return new FileArgument(this);
    }

    public String[] getFileFilterComponents() {
        return this.fileFilterComponents.toArray(new String[this.fileFilterComponents.size()]);
    }

    private List<String> copyFileFilterComponents(List<String> fileFiltersComponentsToCopy) {
        return new ArrayList<String>(fileFiltersComponentsToCopy);
    }

    private List<String> createFileFilterComponents(String filterFileSuffixes) {
        ArrayList<String> tmpFileFilterComponents = new ArrayList<String>();
        if (filterFileSuffixes != null && filterFileSuffixes.length() > 0) {
            String[] splits;
            for (String filterFileSuffix : splits = filterFileSuffixes.split(filterFileSuffixes, 44)) {
                tmpFileFilterComponents.add("*." + filterFileSuffix.trim());
            }
        }
        return tmpFileFilterComponents;
    }
}

