/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.argument;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;

public class QueryArgument
extends Argument {
    private final QueryEvaluator queryEvaluator;
    private final String query;

    public QueryArgument(ArgumentDescription argDescr, Boolean optional, Object defaultValue, String query, List<String> operators, Boolean advanced, Integer displayWidth, QueryEvaluator queryEvaluator) {
        super(ArgumentType.QUERY, argDescr, optional, defaultValue, DEFERRED_LIST, null, operators, advanced, displayWidth);
        this.queryEvaluator = queryEvaluator;
        this.query = query;
    }

    public QueryArgument(QueryArgument arg) {
        super(arg);
        this.queryEvaluator = arg.queryEvaluator;
        this.query = arg.query;
    }

    @Override
    public QueryArgument copyArgument() {
        return new QueryArgument(this);
    }

    @Override
    public void loadDeferredValues(boolean checkForHeader, Function<String, BufferedReader> fileResolver) throws IOException {
        ArrayList<String[]> values = new ArrayList<String[]>();
        List queryResults = this.queryEvaluator.asList(this.query);
        for (String line : queryResults) {
            values.add(line.split("\t"));
        }
        this.allowedValues = values;
        this.fireContentsChanged(0, this.allowedValues.size());
    }

    @Override
    public boolean hasDeferredValues() {
        return true;
    }

    @Override
    protected void checkAllowed(Object theValue) {
    }
}

