/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import gorsat.Regression.LinearAlgebra;
import gorsat.Regression.LogisticRegression;

class SingleCovariateLogisticRegression
extends LogisticRegression {
    SingleCovariateLogisticRegression(int maximumNumberOfSamples) {
        super(1, maximumNumberOfSamples);
    }

    @Override
    protected void computeTestStats() {
        double det = this.hessian[0][0] * this.hessian[1][1] - this.hessian[1][0] * this.hessian[1][0];
        this.zStats[0] = this.beta[0] / Math.sqrt(this.hessian[1][1] / det);
        this.zStats[1] = this.beta[1] / Math.sqrt(this.hessian[0][0] / det);
    }

    @Override
    protected void updateGradientAndHessian(double[][] x, boolean[] y) {
        double[] xi = x[0];
        double beta0 = this.beta[0];
        double beta1 = this.beta[1];
        for (int i = 0; i < this.numberOfSamples; ++i) {
            double tmp1;
            this.oneOver[i] = tmp1 = this.sf.sigmoid(beta0 + beta1 * xi[i]);
            double tmp2 = 1.0 - tmp1;
            this.prod[i] = tmp2 * tmp1;
            this.gradMult[i] = y[i] ? tmp2 : -tmp1;
        }
        this.gradient[0] = LinearAlgebra.sum(this.gradMult, this.numberOfSamples);
        this.gradient[1] = LinearAlgebra.dotProd(this.gradMult, xi, this.numberOfSamples);
        this.hessian[0][0] = LinearAlgebra.sum(this.prod, this.numberOfSamples);
        this.hessian[1][0] = LinearAlgebra.dotProd(xi, this.prod, this.numberOfSamples);
        this.hessian[1][1] = LinearAlgebra.tripleDotProd(xi, xi, this.prod, this.numberOfSamples);
    }

    @Override
    protected void updateGradientAndHessianFirstRun(double[][] x, boolean[] y) {
        for (int j = 0; j < this.numberOfSamples; ++j) {
            this.gradMult[j] = y[j] ? 0.5 : -0.5;
        }
        this.gradient[0] = LinearAlgebra.sum(this.gradMult, this.numberOfSamples);
        this.gradient[1] = LinearAlgebra.dotProd(this.gradMult, x[0], this.numberOfSamples);
        this.hessian[0][0] = (double)this.numberOfSamples * 0.25;
        this.hessian[1][0] = LinearAlgebra.sum(x[0], this.numberOfSamples) * 0.25;
        this.hessian[1][1] = LinearAlgebra.dotProd(x[0], x[0], this.numberOfSamples) * 0.25;
    }
}

