/*
 * Decompiled with CFR 0.152.
 */
package gorsat.external.plink;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

public class GORLine
implements Comparable<GORLine> {
    private final Path p;
    private BufferedReader br;
    private String currentLine;
    private String currentChr;
    private int currentPos;
    private final String name;
    private String header;

    GORLine(String name, Path p) throws IOException {
        this.p = p;
        this.name = name;
        this.next();
    }

    public String toString() {
        if (this.p != null) {
            return this.name == null ? "chr" + this.currentLine : "chr" + this.currentLine + "\t" + this.name;
        }
        return this.currentLine;
    }

    public String getHeader() {
        return this.header;
    }

    public void close() throws IOException {
        this.br.close();
    }

    public GORLine next() throws IOException {
        if (this.br == null) {
            this.br = Files.newBufferedReader(this.p);
            this.header = this.br.readLine();
        }
        this.currentLine = this.br.readLine();
        if (this.currentLine != null) {
            int i = this.currentLine.indexOf(9);
            int k = this.currentLine.indexOf(9, i + 1);
            this.currentChr = this.currentLine.substring(0, i);
            this.currentPos = Integer.parseInt(this.currentLine.substring(i + 1, k));
            return this;
        }
        this.close();
        return null;
    }

    @Override
    public int compareTo(GORLine other) {
        int ret = this.currentChr.compareTo(other.currentChr);
        if (ret == 0) {
            return this.currentPos - other.currentPos;
        }
        return ret;
    }
}

