/*
 * Decompiled with CFR 0.152.
 */
package gorsat.gtgen;

import gorsat.gtgen.PowerLookupTable;
import org.apache.commons.math3.util.FastMath;

public class GPParser {
    private static final double[] plLookupTable = new double[100];

    private GPParser() {
    }

    public static double[] plToGp(CharSequence plTriplet, char sep) {
        int[] gls = GPParser.parseIntTriplet(plTriplet, sep);
        double x0 = gls[0] < 100 ? plLookupTable[gls[0]] : 0.0;
        double x1 = gls[1] < 100 ? plLookupTable[gls[1]] : 0.0;
        double x2 = gls[2] < 100 ? plLookupTable[gls[2]] : 0.0;
        return new double[]{x0, x1, x2};
    }

    public static double[] glToGp(CharSequence glTriplet, char sep) {
        double[] gls = GPParser.parseDoubleTriplet(glTriplet, sep);
        double x0 = FastMath.pow((double)10.0, (double)gls[0]);
        double x1 = FastMath.pow((double)10.0, (double)gls[1]);
        double x2 = FastMath.pow((double)10.0, (double)gls[2]);
        double sum_rec = 1.0 / (x0 + x1 + x2);
        gls[0] = x0 * sum_rec;
        gls[1] = x1 * sum_rec;
        gls[2] = x2 * sum_rec;
        return gls;
    }

    public static double[] glCcToGp(int gl, char cc) {
        double hp = PowerLookupTable.pow(10.0, gl);
        if (cc == '0') {
            double hp1 = 1.0 / (hp + 1.0);
            return new double[]{hp * hp1, hp1, 0.0};
        }
        if (cc == '1') {
            double hp2 = 1.0 / (hp + 2.0);
            return new double[]{hp2, hp * hp2, hp2};
        }
        if (cc == '2') {
            double hp1 = 1.0 / (hp + 1.0);
            return new double[]{0.0, hp1, hp * hp1};
        }
        throw new IllegalArgumentException();
    }

    public static double[] parseDoubleTriplet(CharSequence cs, char sep) {
        int begin = 0;
        int end = 0;
        while (cs.charAt(end) != sep) {
            ++end;
        }
        double p0 = GPParser.parseDouble(cs, begin, end);
        begin = ++end;
        while (cs.charAt(end) != sep) {
            ++end;
        }
        double p1 = GPParser.parseDouble(cs, begin, end);
        double p2 = GPParser.parseDouble(cs, end + 1, cs.length());
        return new double[]{p0, p1, p2};
    }

    public static double parseDouble(CharSequence cs, int begin, int end) {
        char c;
        int idx;
        boolean is_negative;
        double x = 0.0;
        if (cs.charAt(begin) == '-') {
            is_negative = true;
            idx = begin + 1;
        } else {
            is_negative = false;
            idx = begin;
        }
        while (idx < end && (c = cs.charAt(idx++)) != '.') {
            if (c == 'e' || c == 'E') {
                int exponent = GPParser.parseInt(cs, idx, end);
                double scale = PowerLookupTable.pow(10.0, exponent);
                return is_negative ? -x : (x *= scale);
            }
            x = 10.0 * x + (double)(c - 48);
        }
        double ten_pow = 0.1;
        while (idx < end) {
            char c2;
            if ((c2 = cs.charAt(idx++)) == 'e' || c2 == 'E') {
                int exponent = GPParser.parseInt(cs, idx, end);
                double scale = PowerLookupTable.pow(10.0, exponent);
                return is_negative ? -x : (x *= scale);
            }
            x += (double)(c2 - 48) * ten_pow;
            ten_pow *= 0.1;
        }
        return is_negative ? -x : x;
    }

    public static int[] parseIntTriplet(CharSequence cs, char sep) {
        int begin = 0;
        int end = 0;
        while (cs.charAt(end) != sep) {
            ++end;
        }
        int x0 = GPParser.parseInt(cs, begin, end);
        begin = ++end;
        while (cs.charAt(end) != sep) {
            ++end;
        }
        int x1 = GPParser.parseInt(cs, begin, end);
        int x2 = GPParser.parseInt(cs, end + 1, cs.length());
        return new int[]{x0, x1, x2};
    }

    public static int parseInt(CharSequence cs, int begin, int end) {
        int idx;
        boolean isNegative;
        if (cs.charAt(begin) == '-') {
            isNegative = true;
            idx = begin + 1;
        } else {
            isNegative = false;
            idx = begin;
        }
        int x = 0;
        while (idx < end) {
            x = 10 * x + (cs.charAt(idx) - 48);
            ++idx;
        }
        return isNegative ? -x : x;
    }

    static {
        for (int i = 0; i < plLookupTable.length; ++i) {
            GPParser.plLookupTable[i] = FastMath.pow((double)10.0, (double)(-0.1 * (double)i));
        }
    }
}

