/*
 * Decompiled with CFR 0.152.
 */
package gorsat.gtgen;

import gorsat.gtgen.PowerLookupTable;
import java.util.Arrays;

public class GTGen {
    private final int n;
    private int m;
    private double priorAF;
    private boolean hasPrior;
    private final double[] qs;
    private final boolean[] hasData;
    private double pAA;
    private double pAB;
    private double pBB;
    private int covCount;
    private final PowerLookupTable ePlt;
    private final PowerLookupTable oneMinusEPlt;
    private final PowerLookupTable halfPlt;

    public GTGen(double e, int n) {
        this.n = n;
        this.qs = new double[3 * n];
        this.hasData = new boolean[n];
        this.ePlt = PowerLookupTable.getLookupTable(e);
        this.oneMinusEPlt = PowerLookupTable.getLookupTable(1.0 - e);
        this.halfPlt = PowerLookupTable.getLookupTable(0.5);
    }

    public void reset() {
        Arrays.fill(this.hasData, false);
        this.hasPrior = false;
        this.covCount = 0;
    }

    public int getNumberOfSamples() {
        return this.n;
    }

    public double getPriorAf() {
        return this.priorAF;
    }

    public int getPriorAn() {
        return this.m;
    }

    public void setAF(double af) {
        this.pAA = (1.0 - af) * (1.0 - af);
        this.pAB = 2.0 * af * (1.0 - af);
        this.pBB = af * af;
    }

    public double getAF() {
        return 0.5 * this.pAB + this.pBB;
    }

    public boolean hasCoverage(int idx) {
        return this.hasData[idx];
    }

    public int getAn() {
        return this.hasPrior ? this.m + this.covCount : this.covCount;
    }

    public void setPrior(double af, int m) {
        this.priorAF = af;
        this.m = m;
        this.hasPrior = true;
    }

    public void addData(int sampleIdx, double pAA, double pAB, double pBB) {
        if (this.hasData[sampleIdx]) {
            throw new IllegalStateException("The data for sample " + sampleIdx + " has already been set.");
        }
        this.hasData[sampleIdx] = true;
        ++this.covCount;
        this.qs[3 * sampleIdx] = pAA / this.pAA;
        this.qs[3 * sampleIdx + 1] = pAB / this.pAB;
        this.qs[3 * sampleIdx + 2] = pBB / this.pBB;
    }

    public void addData(int sampleIdx, int call, int depth) {
        if (this.hasData[sampleIdx]) {
            throw new IllegalStateException("The data for sample " + sampleIdx + " has already been set.");
        }
        this.hasData[sampleIdx] = true;
        ++this.covCount;
        this.qs[3 * sampleIdx] = this.ePlt.pow(call) * this.oneMinusEPlt.pow(depth - call);
        this.qs[3 * sampleIdx + 1] = this.halfPlt.pow(depth);
        this.qs[3 * sampleIdx + 2] = this.ePlt.pow(depth - call) * this.oneMinusEPlt.pow(call);
    }

    public boolean impute(double[] gts, double tol, int maxIt) {
        if (this.covCount > 0) {
            boolean converged = this.computeAf(tol, maxIt);
            if (converged) {
                this.fillGenotypes(gts);
            }
            return converged;
        }
        Arrays.fill(gts, 0.0);
        return true;
    }

    private void fillGenotypes(double[] gts) {
        for (int i = 0; i < this.n; ++i) {
            if (this.hasData[i]) {
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                gts[3 * i] = x0 * sum_rec;
                gts[3 * i + 1] = x1 * sum_rec;
                gts[3 * i + 2] = x2 * sum_rec;
                continue;
            }
            gts[3 * i] = 0.0;
            gts[3 * i + 1] = 0.0;
            gts[3 * i + 2] = 0.0;
        }
    }

    private boolean computeAf(double tol, int maxIt) {
        if (this.hasPrior) {
            return this.computeAfWithPrior(tol, maxIt);
        }
        return this.computeAfWithoutPrior(tol, maxIt);
    }

    private boolean computeAfWithPrior(double tol, int maxIt) {
        this.setAF(this.priorAF);
        double p0AA = this.pAA;
        double p0AB = this.pAB;
        double p0BB = this.pBB;
        double error = Double.POSITIVE_INFINITY;
        int it = 0;
        while (error > tol && it++ < maxIt) {
            double sum_pAA = (double)this.m * p0AA;
            double sum_pAB = (double)this.m * p0AB;
            double sum_pBB = (double)this.m * p0BB;
            for (int i = 0; i < this.n; ++i) {
                if (!this.hasData[i]) continue;
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                sum_pAA += x0 * sum_rec;
                sum_pAB += x1 * sum_rec;
                sum_pBB += x2 * sum_rec;
            }
            double new_pAA = sum_pAA / (double)(this.m + this.covCount);
            double new_pAB = sum_pAB / (double)(this.m + this.covCount);
            double new_pBB = sum_pBB / (double)(this.m + this.covCount);
            error = Math.max(Math.abs(new_pAA - this.pAA), Math.max(Math.abs(new_pAB - this.pAB), Math.abs(new_pBB - this.pBB)));
            this.pAA = new_pAA;
            this.pAB = new_pAB;
            this.pBB = new_pBB;
        }
        return error <= tol;
    }

    private boolean computeAfWithoutPrior(double tol, int maxIt) {
        double error = Double.POSITIVE_INFINITY;
        int it = 0;
        while (error > tol && it++ < maxIt) {
            double sum_pAA = 0.0;
            double sum_pAB = 0.0;
            double sum_pBB = 0.0;
            for (int i = 0; i < this.n; ++i) {
                if (!this.hasData[i]) continue;
                double x0 = this.qs[3 * i] * this.pAA;
                double x1 = this.qs[3 * i + 1] * this.pAB;
                double x2 = this.qs[3 * i + 2] * this.pBB;
                double sum_rec = 1.0 / (x0 + x1 + x2);
                sum_pAA += x0 * sum_rec;
                sum_pAB += x1 * sum_rec;
                sum_pBB += x2 * sum_rec;
            }
            double new_pAA = sum_pAA / (double)this.covCount;
            double new_pAB = sum_pAB / (double)this.covCount;
            double new_pBB = sum_pBB / (double)this.covCount;
            error = Math.max(Math.abs(new_pAA - this.pAA), Math.max(Math.abs(new_pAB - this.pAB), Math.abs(new_pBB - this.pBB)));
            this.pAA = new_pAA;
            this.pAB = new_pAB;
            this.pBB = new_pBB;
        }
        return error <= tol;
    }
}

