/*
 * Decompiled with CFR 0.152.
 */
package gorsat.parser;

import gorsat.parser.CalcLambdaDouble;
import gorsat.parser.CalcLambdaInteger;
import gorsat.parser.CalcLambdaNumeric;
import gorsat.parser.CalcLambdaString;
import gorsat.parser.CalcLambdaVariable;
import gorsat.parser.CvpLongLambda;
import gorsat.parser.FunctionTypes;
import gorsat.parser.LongType;
import gorsat.parser.Numeric;
import gorsat.parser.TypedCalcLambda;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.model.ColumnValueProvider;

public class CalcLambdaLong
extends CalcLambdaNumeric
implements LongType {
    private CvpLongLambda lambda;

    public CalcLambdaLong(CvpLongLambda lambda) {
        this.lambda = lambda;
    }

    @Override
    public String getType() {
        return FunctionTypes.LongFun();
    }

    @Override
    public int evaluateInt(ColumnValueProvider columnValueProvider) {
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public long evaluateLong(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public double evaluateDouble(ColumnValueProvider cvp) {
        return this.lambda.evaluate(cvp);
    }

    @Override
    public String evaluateString(ColumnValueProvider cvp) {
        long value = this.lambda.evaluate(cvp);
        return String.valueOf(value);
    }

    @Override
    public boolean evaluateBoolean(ColumnValueProvider cvp) {
        return false;
    }

    @Override
    public TypedCalcLambda addedTo(TypedCalcLambda left) {
        return left.add(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaVariable other) {
        return other.toLambda().addedTo(this);
    }

    @Override
    public TypedCalcLambda add(CalcLambdaString other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(String other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda add(CalcLambdaInteger other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda add(int other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + (long)other;
        return this;
    }

    @Override
    public TypedCalcLambda add(CalcLambdaLong other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda add(long other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) + other;
        return this;
    }

    @Override
    public TypedCalcLambda add(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) + other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda add(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) + other);
    }

    @Override
    public TypedCalcLambda subtractedFrom(TypedCalcLambda other) {
        return other.subtract(this);
    }

    @Override
    public TypedCalcLambda subtract(int other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) - (long)other);
    }

    @Override
    public TypedCalcLambda subtract(long other) {
        return new CalcLambdaLong(cvp -> this.evaluateLong(cvp) - other);
    }

    @Override
    public TypedCalcLambda subtract(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) - other);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaVariable other) {
        return other.toLambda().subtractedFrom(this);
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaInteger other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) - other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) - other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda subtract(CalcLambdaLong other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) - other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda multipliedWith(TypedCalcLambda left) {
        return left.multiply(this);
    }

    @Override
    public TypedCalcLambda multiply(int other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * (long)other;
        return this;
    }

    @Override
    public TypedCalcLambda multiply(long other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other;
        return this;
    }

    @Override
    public TypedCalcLambda multiply(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) * other);
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaInteger other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaLong other) {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> prev.evaluate(cvp) * other.evaluateLong(cvp);
        return this;
    }

    @Override
    public TypedCalcLambda multiply(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) * other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda dividedInto(TypedCalcLambda left) {
        return left.divide(this);
    }

    @Override
    public TypedCalcLambda divide(int other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / (double)other);
    }

    @Override
    public TypedCalcLambda divide(long other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / (double)other);
    }

    @Override
    public TypedCalcLambda divide(double other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other);
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaVariable other) {
        throw TypedCalcLambda.getNotImplemented();
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaInteger other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaLong other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda divide(CalcLambdaDouble other) {
        return new CalcLambdaDouble(cvp -> this.evaluateDouble(cvp) / other.evaluateDouble(cvp));
    }

    @Override
    public TypedCalcLambda pow(TypedCalcLambda o) {
        TypedCalcLambda other = o.toLambda();
        if (!(other instanceof Numeric)) {
            throw new GorParsingException("Number expected for ^ operator");
        }
        if (other instanceof CalcLambdaLong || other instanceof CalcLambdaInteger) {
            CvpLongLambda prev = this.lambda;
            this.lambda = cvp -> (long)Math.pow(prev.evaluate(cvp), other.evaluateLong(cvp));
            return this;
        }
        if (other instanceof CalcLambdaDouble) {
            return new CalcLambdaDouble(cvp -> Math.pow(this.evaluateDouble(cvp), other.evaluateDouble(cvp)));
        }
        throw TypedCalcLambda.getIncompatibleTypes();
    }

    @Override
    public TypedCalcLambda negate() {
        CvpLongLambda prev = this.lambda;
        this.lambda = cvp -> -prev.evaluate(cvp);
        return this;
    }
}

