/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor;

import gorsat.Commands.CommandInfo;
import gorsat.Commands.CommandParseUtilities;
import gorsat.process.GorPipeCommands;
import java.util.HashSet;
import java.util.Set;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.gorpipe.exceptions.GorParsingException;
import org.gorpipe.gor.GorScriptBaseVisitor;
import org.gorpipe.gor.GorScriptParser;
import org.gorpipe.gor.SyntaxChecker;

public class SemanticChecker
extends GorScriptBaseVisitor<Boolean> {
    private final Set<String> virtualRelationsCreated = new HashSet<String>();
    private final Set<String> virtualRelationsReferenced = new HashSet<String>();

    public void validate(String input) {
        SyntaxChecker syntaxChecker = new SyntaxChecker();
        ParserRuleContext scriptContext = syntaxChecker.parse(input);
        scriptContext.accept((ParseTreeVisitor)this);
        this.virtualRelationsCreated.forEach(name -> {
            if (!this.virtualRelationsReferenced.contains(name)) {
                throw new GorParsingException(String.format("Create statement '%s' is never referenced", name), 0, 0);
            }
        });
    }

    @Override
    public Boolean visitVirtual_relation_name(GorScriptParser.Virtual_relation_nameContext ctx) {
        TerminalNode nameNode = (TerminalNode)ctx.getChild(0);
        String name = nameNode.toString().toUpperCase();
        if (this.virtualRelationsCreated.contains(name)) {
            throw new GorParsingException(String.format("Duplicate name of create statement: %s", name), 0, 0);
        }
        this.virtualRelationsCreated.add(name.toUpperCase());
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitGeneric_command(GorScriptParser.Generic_commandContext ctx) {
        TerminalNode cmdNode = (TerminalNode)ctx.getChild(0);
        String cmd = cmdNode.toString().toUpperCase();
        CommandInfo commandInfo = GorPipeCommands.getInfo(cmd);
        if (commandInfo == null) {
            throw new GorParsingException(String.format("Invalid command %s", cmd), ctx.start.getLine(), ctx.start.getCharPositionInLine());
        }
        GorScriptParser.Options_and_argsContext optionsAndArgs = (GorScriptParser.Options_and_argsContext)ctx.getChild(1);
        int a = optionsAndArgs.start.getStartIndex();
        int b = optionsAndArgs.stop.getStopIndex();
        String optionsAndArgsText = "";
        if (a < b) {
            Interval interval = new Interval(a, b);
            optionsAndArgsText = optionsAndArgs.start.getInputStream().getText(interval);
        }
        String[] args = CommandParseUtilities.quoteSafeSplit((String)optionsAndArgsText, (char)' ');
        try {
            commandInfo.validateArguments(args);
        }
        catch (GorParsingException gpe) {
            throw new GorParsingException(gpe.getMessage(), optionsAndArgs.start.getLine(), optionsAndArgs.start.getCharPositionInLine());
        }
        return (Boolean)super.visitGeneric_command(ctx);
    }

    @Override
    public Boolean visitVirtual_relation(GorScriptParser.Virtual_relationContext ctx) {
        TerminalNode nameNode = (TerminalNode)ctx.getChild(1);
        String name = nameNode.toString().toUpperCase();
        this.virtualRelationsReferenced.add(name);
        return Boolean.TRUE;
    }

    static {
        GorPipeCommands.register();
    }
}

