/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli;

import java.util.Formatter;
import java.util.LinkedList;
import java.util.List;

class Table {
    private final String header;
    private final List<String[]> rows = new LinkedList<String[]>();
    private final List<Integer> colwidths = new LinkedList<Integer>();

    Table(String header) {
        this.header = header;
    }

    void addHeader(String ... header) {
        this.addRow(header);
        String[] underlines = new String[header.length];
        for (int i = 0; i < header.length; ++i) {
            int length = header[i].length();
            StringBuilder sb = new StringBuilder(length);
            for (int k = 0; k < length; ++k) {
                sb.append("=");
            }
            underlines[i] = sb.toString();
        }
        this.addRow(underlines);
    }

    void addRow(String ... cols) {
        this.rows.add(cols);
        for (int i = 0; i < cols.length; ++i) {
            int width = cols[i].length();
            if (i >= this.colwidths.size()) {
                this.colwidths.add(width);
                continue;
            }
            this.colwidths.set(i, Math.max(this.colwidths.get(i), width));
        }
    }

    public String toString() {
        StringBuilder formatBuilder = new StringBuilder();
        for (int width : this.colwidths) {
            formatBuilder.append("%-").append(width).append(".").append(width).append("s  ");
        }
        formatBuilder.replace(formatBuilder.length() - 2, formatBuilder.length(), "%n");
        String format = formatBuilder.toString();
        try (Formatter formatter = new Formatter();){
            for (Object[] objectArray : this.rows) {
                formatter.format(format, objectArray);
            }
            String string = this.header + "\n" + formatter.out().toString();
            return string;
        }
    }
}

