/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.cache;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gorpipe.gor.util.StringUtil;

class AnalysisResult {
    private final Path cacheFolder;
    private final Map<String, Integer> extensionCountMap = new HashMap<String, Integer>();
    private final List<String> fileList = new ArrayList<String>();

    AnalysisResult(Path cacheFolder) {
        this.cacheFolder = cacheFolder;
    }

    Map<String, Integer> getExtensionCountMap() {
        return Collections.unmodifiableMap(this.extensionCountMap);
    }

    List<String> getFileList() {
        return Collections.unmodifiableList(this.fileList);
    }

    public void process(Path file) {
        if (!file.startsWith(this.cacheFolder)) {
            return;
        }
        Path relativeFilePath = this.cacheFolder.relativize(file);
        this.fileList.add(relativeFilePath.toString());
        String extension = AnalysisResult.getFileExtension(relativeFilePath);
        if (!StringUtil.isEmpty((Object)extension)) {
            if (this.extensionCountMap.containsKey(extension)) {
                this.extensionCountMap.replace(extension, this.extensionCountMap.get(extension) + 1);
            } else {
                this.extensionCountMap.put(extension, 1);
            }
        }
    }

    private static String getFileExtension(Path file) {
        String extension = "";
        try {
            if (file != null) {
                String name = file.getFileName().toString();
                extension = name.substring(name.lastIndexOf(46));
            }
        }
        catch (Exception e) {
            extension = "";
        }
        return extension.toLowerCase().trim();
    }
}

