/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.cache;

import java.io.File;
import org.gorpipe.gor.cli.cache.FilterOptions;
import org.gorpipe.gor.driver.meta.DataType;
import picocli.CommandLine;

@CommandLine.Command(name="touch", aliases={"t"}, description={"Touch files in cache."})
public class TouchCommand
extends FilterOptions
implements Runnable {
    private int fileCounter;
    private String extra = "";

    @Override
    public void run() {
        this.extra = this.dryRun ? " (dryrun)" : "";
        this.touchCache(this.cachePath);
    }

    private void touchCache(File cachePath) {
        this.touchFiles(cachePath);
        System.err.printf("Touched %1$d files%2$s%n", this.fileCounter, this.extra);
    }

    private void touchFiles(File parentFile) {
        File[] fileArray = parentFile.listFiles();
        if (fileArray == null) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        for (File file : fileArray) {
            if (file.isFile()) {
                DataType type = DataType.fromFileName((String)file.getName());
                if (type == null || !file.setLastModified(timestamp)) continue;
                ++this.fileCounter;
                if (!this.verbose) continue;
                System.err.println("Touching file: " + file.toString() + this.extra);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.touchFiles(file);
        }
    }
}

