/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.time.Duration;
import org.gorpipe.gor.cli.manager.ManagerOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.lock.TableLock;
import picocli.CommandLine;

@CommandLine.Command(name="islock", description={"Test the atate of lock with lock name. Returns 'Locked' og 'Unlocked' based on lock state."}, header={"Test state of names lock."})
public class TestIsLockCommand
extends ManagerOptions
implements Runnable {
    @CommandLine.Parameters(index="1", arity="1", paramLabel="LOCKNAME", description={"Lock name to test."})
    String lockName;

    @Override
    public void run() {
        Duration lockTimeoutDuration = Duration.ofSeconds(this.lockTimeout);
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).lockTimeout(lockTimeoutDuration).build();
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        try (TableLock lock = TableLock.acquireWrite(tm.getLockType(), (BaseTable)table, (String)this.lockName, (Duration)Duration.ZERO);){
            System.out.println(lock.isValid() ? "Unlocked" : "Locked " + lock.reservedTo());
        }
    }
}

