/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.cli.manager;

import java.time.Duration;
import org.gorpipe.gor.cli.manager.ManagerOptions;
import org.gorpipe.gor.manager.TableManager;
import org.gorpipe.gor.table.BaseTable;
import org.gorpipe.gor.table.lock.TableLock;
import picocli.CommandLine;

@CommandLine.Command(name="readlock", description={"Test read lock with lock name and lock period."}, header={"Test read lock."})
public class TestReadLockCommand
extends ManagerOptions
implements Runnable {
    @CommandLine.Parameters(index="1", arity="1", paramLabel="LOCKNAME", description={"Lock name to test."})
    String lockName;
    @CommandLine.Parameters(index="2", arity="1", paramLabel="PERIOD", description={"Lock duration in milliseconds"})
    long period;

    @Override
    public void run() {
        Duration lockTimeoutDuration = Duration.ofSeconds(this.lockTimeout);
        TableManager tm = TableManager.newBuilder().useHistory(!this.nohistory).lockTimeout(lockTimeoutDuration).build();
        BaseTable table = tm.initTable(this.dictionaryFile.toPath());
        try (TableLock lock = TableLock.acquireRead(tm.getLockType(), (BaseTable)table, (String)this.lockName, (Duration)lockTimeoutDuration);){
            Thread.sleep(this.period);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

