/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.gava;

import java.util.List;
import org.gorpipe.gor.gava.CollapsedCounts;
import org.gorpipe.gor.gava.GavaLogLikelihood;
import org.gorpipe.gor.gava.MathArrayUtils;

public class RecessiveLogLikelihood
extends GavaLogLikelihood {
    @Override
    public double computeLogLikelihood(List<CollapsedCounts> collapsedCounts, int[] perm, boolean debug) {
        int numSubjects = perm.length;
        assert (numSubjects == this.numCases + this.numControls);
        int m = collapsedCounts.size();
        double[] altValues = this.calcVariantLikelihoods(collapsedCounts, perm);
        int[] order = MathArrayUtils.getSortingPermutationInt(altValues);
        int[] pnAlleleCounts = new int[numSubjects];
        boolean[] hasDiseaseVariant = new boolean[numSubjects];
        int numAffWithDiseaseVariant = 0;
        double logSum = 0.0;
        for (int k = order.length - 1; k >= 0; --k) {
            int j1 = order[k] / m;
            int j2 = order[k] % m;
            if (j1 < j2) continue;
            CollapsedCounts counts1 = collapsedCounts.get(j1);
            CollapsedCounts counts2 = collapsedCounts.get(j2);
            int caseCopies = 0;
            int controlCopies = 0;
            for (int i = 0; i < numSubjects; ++i) {
                int count1 = counts1.callCounts[perm[i]];
                int count2 = counts2.callCounts[perm[i]];
                if ((j1 != j2 || count1 < 2) && (j1 == j2 || count1 != 1 || count2 != 1)) continue;
                if (i < this.numControls) {
                    ++controlCopies;
                } else if (pnAlleleCounts[i] == 0 || this.noMaxAlleleCounts) {
                    ++caseCopies;
                }
                int n = i;
                pnAlleleCounts[n] = pnAlleleCounts[n] + 1;
            }
            if (this.controlPenetrance >= 0 && controlCopies > this.controlPenetrance) break;
            int allCopies = caseCopies + controlCopies;
            double p = (double)allCopies / (double)numSubjects;
            double pA = (double)caseCopies / (double)this.numCases;
            double pU = Math.min((double)controlCopies / (double)this.numControls, this.upperFreqThreshold);
            if (this.includeProtective || pA > pU) {
                double logDiff = Math.log(counts1.nullScore + counts2.nullScore) - Math.log(counts1.altScore + counts2.altScore);
                if (p > 0.0 && p < 1.0) {
                    logDiff += (double)allCopies * Math.log(p) + (double)(numSubjects - allCopies) * Math.log(1.0 - p);
                }
                if (pA > 0.0 && pA < 1.0) {
                    logDiff -= (double)caseCopies * Math.log(pA) + (double)(this.numCases - caseCopies) * Math.log(1.0 - pA);
                }
                if (pU > 0.0 && pU < 1.0) {
                    logDiff -= (double)controlCopies * Math.log(pU) + (double)(this.numControls - controlCopies) * Math.log(1.0 - pU);
                }
                if (logDiff < 0.0) {
                    logSum += logDiff;
                    if (this.casePenetrance >= 0) {
                        for (int i = this.numControls; i < numSubjects; ++i) {
                            int count1 = counts1.callCounts[perm[i]];
                            int count2 = counts2.callCounts[perm[i]];
                            if ((j1 != j2 || count1 < 2) && (j1 == j2 || count1 <= 0 || count2 <= 0) || hasDiseaseVariant[i]) continue;
                            hasDiseaseVariant[i] = true;
                            ++numAffWithDiseaseVariant;
                        }
                    }
                }
            }
            if (!debug) continue;
            String prefix = this.includeProtective || pA > pU ? "incl" : "excl";
            System.err.println(prefix + "\t" + caseCopies + "\t" + controlCopies + "\t" + pA + "\t" + pU + "\t" + -2.0 * logSum);
        }
        if (this.casePenetrance >= 0 && numAffWithDiseaseVariant < this.numCases - this.casePenetrance) {
            return 0.0;
        }
        return logSum;
    }

    private double[] calcVariantLikelihoods(List<CollapsedCounts> collapsedCounts, int[] perm) {
        int numSubjects = perm.length;
        int m = collapsedCounts.size();
        double[] altValues = new double[m * m];
        for (int j1 = 0; j1 < m; ++j1) {
            CollapsedCounts counts1 = collapsedCounts.get(j1);
            for (int j2 = 0; j2 < m; ++j2) {
                CollapsedCounts counts2 = collapsedCounts.get(j2);
                int caseCopies = 0;
                int controlCopies = 0;
                for (int i = 0; i < numSubjects; ++i) {
                    int count1 = counts1.callCounts[perm[i]];
                    int count2 = counts2.callCounts[perm[i]];
                    if ((j1 != j2 || count1 < 2) && (j1 == j2 || count1 != 1 || count2 != 1)) continue;
                    if (i < this.numControls) {
                        ++controlCopies;
                        continue;
                    }
                    ++caseCopies;
                }
                int allCopies = caseCopies + controlCopies;
                double p = (double)allCopies / (double)numSubjects;
                double pA = (double)caseCopies / (double)this.numCases;
                double pU = Math.min((double)controlCopies / (double)this.numControls, this.upperFreqThreshold);
                if (!this.includeProtective && !(pA > pU)) continue;
                int k = j1 * m + j2;
                altValues[k] = Math.log(counts1.altScore + counts2.altScore) - Math.log(counts1.nullScore + counts2.nullScore);
                if (pA > 0.0 && pA < 1.0) {
                    int n = k;
                    altValues[n] = altValues[n] + ((double)caseCopies * Math.log(pA) + (double)(this.numCases - caseCopies) * Math.log(1.0 - pA));
                }
                if (pU > 0.0 && pU < 1.0) {
                    int n = k;
                    altValues[n] = altValues[n] + ((double)controlCopies * Math.log(pU) + (double)(this.numControls - controlCopies) * Math.log(1.0 - pU));
                }
                if (!(p > 0.0) || !(p < 1.0)) continue;
                int n = k;
                altValues[n] = altValues[n] - ((double)allCopies * Math.log(p) + (double)(numSubjects - allCopies) * Math.log(1.0 - p));
            }
        }
        return altValues;
    }
}

