/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory;

import freemarker.template.TemplateException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.gor.model.QueryEvaluator;
import org.gorpipe.gor.model.ReportCommand;
import org.gorpipe.querydialogs.Argument;
import org.gorpipe.querydialogs.Dialog;
import org.gorpipe.querydialogs.DialogDescription;
import org.gorpipe.querydialogs.DialogType;
import org.gorpipe.querydialogs.argument.StringArgument;
import org.gorpipe.querydialogs.factory.ArgumentContent;
import org.gorpipe.querydialogs.factory.ColumnGroup;
import org.gorpipe.querydialogs.factory.Perspective;
import org.gorpipe.querydialogs.factory.PerspectiveDialogDisplayParams;
import org.gorpipe.querydialogs.factory.ReportViewer;

public class PerspectiveDialog
extends Dialog {
    public static final String PROPERTY_HTML_TEMPLATE = "htmlTemplate";
    public final String writePath;
    private final List<Perspective> perspectives;
    private final List<ColumnGroup> columnGroups;
    private final List<ReportCommand> reportCommands;
    private final PerspectiveDialogDisplayParams displayParams;
    private Path dialogsFilePath;
    private String htmlTemplate;
    private Set<Object> initialColumns;
    private ReportViewer reportViewer = null;

    public PerspectiveDialog(Map<String, ? extends Object> attributes, FileReader fileResolver, QueryEvaluator queryEval, DialogDescription dialogDescription, PerspectiveDialogDisplayParams displayParams, DialogType type, String query, String chartScript, String chartExec, String chartColumns, boolean chartDF, List<Argument> arguments, String htmlTemplate, List<? extends Object> initialColumns, List<Perspective> perspectives, List<ColumnGroup> columnGroups, List<ReportCommand> reportCommands, String errorMsgTemplate, String writePath, String longRunningQueryTemplate, String version, String packageVersion, String gitSHA) throws TemplateException {
        super(attributes, fileResolver, queryEval, dialogDescription, type, query, chartScript, chartExec, chartColumns, chartDF, arguments, errorMsgTemplate, longRunningQueryTemplate, version, packageVersion, gitSHA);
        this.displayParams = displayParams;
        this.htmlTemplate = htmlTemplate;
        if (initialColumns != null && !initialColumns.isEmpty()) {
            this.initialColumns = new HashSet<Object>(initialColumns.size());
            for (Object object : initialColumns) {
                if (Number.class.isAssignableFrom(object.getClass())) {
                    this.initialColumns.add(((Number)object).intValue());
                    continue;
                }
                this.initialColumns.add(object.toString().toLowerCase());
            }
        }
        this.perspectives = Collections.unmodifiableList(perspectives);
        this.columnGroups = Collections.unmodifiableList(columnGroups);
        this.reportCommands = Collections.unmodifiableList(reportCommands);
        this.writePath = writePath;
        this.loadReportQueryToTemplateConfig();
        for (Perspective perspective : this.perspectives) {
            perspective.setArgumentMap(this.getArgumentMap());
        }
    }

    public PerspectiveDialog(PerspectiveDialog dlg) throws TemplateException {
        this(dlg.attributes, dlg.getFileResolver(), dlg.getQueryEval(), dlg.dialogDescription, dlg.displayParams, dlg.getType(), dlg.getBaseQuery(), dlg.getBaseChartScript(), dlg.getBaseChartExec(), dlg.getBaseChartColumns(), dlg.getBaseChartDF(), dlg.copyArguments(), dlg.htmlTemplate, dlg.getInitialColumnsCopy(), dlg.getPerspectivesCopies(), dlg.columnGroups, dlg.reportCommands, dlg.errorMsgTemplate, dlg.writePath, dlg.longRunningQueryTemplate, dlg.version, dlg.packageVersion, dlg.gitSHA);
        this.setReportViewer(dlg.reportViewer);
        this.dialogsFilePath = dlg.dialogsFilePath;
    }

    @Deprecated
    public String getHtmlTemplate() {
        return this.htmlTemplate;
    }

    @Deprecated
    public void setHtmlTemplate(String htmlTemplate) {
        this.htmlTemplate = htmlTemplate;
        this.firePropertyChange(PROPERTY_HTML_TEMPLATE, this.htmlTemplate, this.htmlTemplate);
    }

    @Deprecated
    public Set<Object> getInitialColumns() {
        return this.initialColumns;
    }

    public List<Perspective> getPerspectives() {
        return this.perspectives;
    }

    public List<ColumnGroup> getColumnGroups() {
        return this.columnGroups;
    }

    public List<Perspective> getPerspectivesCopies() {
        ArrayList<Perspective> newPerspectives = new ArrayList<Perspective>();
        for (Perspective perspective : this.perspectives) {
            newPerspectives.add(new Perspective(perspective));
        }
        return newPerspectives;
    }

    public boolean verify() {
        String errorMsg = this.getErrorMessage();
        if (errorMsg != null && errorMsg.length() > 0) {
            throw new RuntimeException(errorMsg);
        }
        return true;
    }

    public boolean checkIfLongRunningQuery() {
        String longRunningMsg = this.determineLongRunningQuery();
        return longRunningMsg != null && longRunningMsg.length() > 0;
    }

    public void setReportViewer(ReportViewer container) {
        this.reportViewer = container;
    }

    public void addNewReportToViewer() {
        if (this.reportViewer == null) {
            throw new RuntimeException("A report viewer must be set prior to adding new report to it");
        }
        this.reportViewer.addReportToViewer(this);
    }

    public List<ReportCommand> getReportCommands() {
        ArrayList<ReportCommand> repCmds = new ArrayList<ReportCommand>();
        for (ReportCommand reportCommand : this.reportCommands) {
            try {
                String interpolateQuery = this.interpolateQuery(reportCommand.getCommandNameAndDigest());
                repCmds.add(new ReportCommand(reportCommand.name, reportCommand.category, interpolateQuery, reportCommand.getRequiredReportColumns()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in drill in report query: " + reportCommand.name + "\n" + ex.getMessage(), ex);
            }
        }
        return repCmds;
    }

    public String getDialogCategory() {
        return this.displayParams.category;
    }

    public Color getImageColor() {
        return this.displayParams.getImageColor();
    }

    public Color getFadeInImageColor() {
        return this.displayParams.getFadeInImageColor();
    }

    public Map<String, Argument> getArgumentMap() {
        return this.argumentMap;
    }

    public void setArgumentValues(Map<String, ArgumentContent> argName2Content) {
        for (Map.Entry<String, ArgumentContent> argName2ContentEntry : argName2Content.entrySet()) {
            Argument argument = (Argument)this.argumentMap.get(argName2ContentEntry.getKey());
            if (argument == null) continue;
            ArgumentContent.Format format = argName2ContentEntry.getValue().format;
            if (format != null && argument instanceof StringArgument) {
                ((StringArgument)argument).setFormat(format.valueFormat);
            }
            argument.setValue(argName2ContentEntry.getValue().value);
        }
    }

    public void setArgumentValues(Path path) throws IOException {
        HashMap<String, ArgumentContent> argName2Content = new HashMap<String, ArgumentContent>();
        try (BufferedReader br = Files.newBufferedReader(path, Charset.forName("UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] splitValues = line.split("\t");
                argName2Content.put(splitValues[0], ArgumentContent.parseContent(splitValues[1]));
            }
        }
        this.setArgumentValues(argName2Content);
    }

    public void saveArgumentValues(Path selFilePath) {
        try (BufferedWriter bw = Files.newBufferedWriter(selFilePath, Charset.forName("UTF-8"), new OpenOption[0]);){
            bw.write("report_yaml\t" + this.getDialogsFilePath() + "\n");
            bw.write("report\t" + this.getName() + "\n");
            for (Map.Entry entry : this.argumentMap.entrySet()) {
                Argument argument = (Argument)entry.getValue();
                Object argValue = argument.getValue();
                if (argValue == null || argValue.toString().length() <= 0) continue;
                String formattedArgValue = this.formatArgumentForStore(argument);
                String argLine = (String)entry.getKey() + "\t" + formattedArgValue + "\n";
                bw.write(argLine);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Error saving argument values", ex);
        }
    }

    public boolean storingAllowed() {
        return this.writePath != null && this.writePath.length() > 0;
    }

    private String formatArgumentForStore(Argument arg) {
        String valueFormat;
        ArgumentContent.Format argContentFormat;
        String argValue = arg.getValue().toString();
        if (arg instanceof StringArgument && (argContentFormat = ArgumentContent.Format.getFormatByValueFormat(valueFormat = ((StringArgument)arg).getFormat())) != null) {
            argValue = argContentFormat.formatForStore(argValue);
        }
        return argValue;
    }

    public Path getDialogsFilePath() {
        return this.dialogsFilePath;
    }

    public void setDialogsFilePath(Path dialogsFilePath) {
        this.dialogsFilePath = dialogsFilePath;
    }

    private void loadReportQueryToTemplateConfig() {
        for (ReportCommand reportCommand : this.reportCommands) {
            this.loadQuery(reportCommand.getCommandNameAndDigest(), reportCommand.command);
        }
    }

    private List<Object> getInitialColumnsCopy() {
        ArrayList<Object> initialColumnsCopyList = new ArrayList<Object>();
        if (this.initialColumns != null) {
            initialColumnsCopyList.addAll(this.initialColumns);
        }
        return initialColumnsCopyList;
    }
}

