/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.querydialogs.factory.builder;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.gorpipe.gor.model.FileReader;
import org.gorpipe.querydialogs.ArgumentDescription;
import org.gorpipe.querydialogs.ArgumentType;
import org.gorpipe.querydialogs.argument.NumberArgument;
import org.gorpipe.querydialogs.factory.ArgumentBuilder;

public class NumberArgumentBuilder
extends ArgumentBuilder {
    public NumberArgumentBuilder(FileReader fileResolver) {
        super(fileResolver);
    }

    @Override
    public NumberArgument build(String name, Map<String, ? extends Object> attributes) {
        Number min = null;
        Number max = null;
        if (attributes.containsKey("range")) {
            String[] range = attributes.get("range").toString().split("\\.\\.");
            min = Double.parseDouble(range[0]);
            max = Double.parseDouble(range[1]);
        } else {
            if (attributes.containsKey("min")) {
                min = (Number)attributes.get("min");
            }
            if (attributes.containsKey("max")) {
                max = (Number)attributes.get("max");
            }
        }
        ArgumentDescription argDescr = this.getArgumentDescription(attributes, name);
        Boolean optional = (Boolean)attributes.get("optional");
        String defaultValue = NumberArgumentBuilder.safeString(attributes.get("default"));
        List<? extends Object> allowed = NumberArgumentBuilder.getAllowedValues(attributes);
        URI valuesPath = this.getValuesPath(attributes);
        List operators = (List)attributes.get("operators");
        Boolean advanced = (Boolean)attributes.get("advanced");
        Integer displayWidth = this.getDisplayWidth(attributes);
        ArgumentType argType = attributes.containsKey("type") ? ArgumentType.valueOf(attributes.get("type").toString().trim().toUpperCase()) : ArgumentType.NUMBER;
        return new NumberArgument(argDescr, optional, defaultValue, allowed, valuesPath, operators, advanced, displayWidth, min, max, argType);
    }
}

