/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Regression;

import java.lang.ref.WeakReference;
import org.apache.commons.math3.util.FastMath;

public class SigmoidFunction {
    private static WeakReference<SigmoidFunction> ref;
    private final double[] lookupTable = new double[2400000];

    private SigmoidFunction() {
        for (int i = 0; i < this.lookupTable.length; ++i) {
            this.lookupTable[i] = 1.0 / (1.0 + FastMath.exp((double)((double)(-i) * 1.0E-5)));
        }
    }

    public static synchronized SigmoidFunction getSigmoidFunction() {
        SigmoidFunction sf;
        if (ref == null || (sf = (SigmoidFunction)ref.get()) == null) {
            sf = new SigmoidFunction();
            ref = new WeakReference<SigmoidFunction>(sf);
        }
        return sf;
    }

    public double sigmoid(double x) {
        if (x < 0.0) {
            if (x < -24.0) {
                return 0.0;
            }
            double px = -x;
            int idx = (int)(100000.0 * px);
            double offset = px - (double)idx * 1.0E-5;
            double est = this.lookupTable[idx];
            return 1.0 - est * (1.0 + (1.0 - est) * offset);
        }
        if (x > 24.0) {
            return 1.0;
        }
        int idx = (int)(100000.0 * x);
        double offset = x - (double)idx * 1.0E-5;
        double est = this.lookupTable[idx];
        return est * (1.0 + (1.0 - est) * offset);
    }
}

