/*
 * Decompiled with CFR 0.152.
 */
package gorsat;

import java.util.Iterator;
import org.gorpipe.gor.model.Row;

public class RowBuffer
implements Iterator<Row> {
    static final int MAX_NUMBER_OF_ROWS = Integer.parseInt(System.getProperty("gor.rowbuffer.max_rows_buffered", "1024"));
    private static final int DEFAULT_MAX_BYTES_IN_BUFFER = Integer.parseInt(System.getProperty("gor.rowbuffer.max_bytes_buffered", "1073741824"));
    private static final int NUM_LINES_TO_ESTIMATE_LINE_SIZE = Integer.parseInt(System.getProperty("gor.rowbuffer.lines_for_size_estimation", "100"));
    private final Row[] rowArray = new Row[MAX_NUMBER_OF_ROWS];
    private int count = 0;
    private int idx = 0;
    private RowBuffer next;
    private int capacity;
    private final int maxBytes;
    private int byteCount = 0;
    private int estimatedAvgLineSize;

    public RowBuffer(int capacity, RowBuffer next) {
        this(capacity, DEFAULT_MAX_BYTES_IN_BUFFER, next);
    }

    public RowBuffer(int capacity, int maxBytes, RowBuffer next) {
        this.maxBytes = maxBytes;
        this.capacity = capacity;
        this.next = next;
        this.estimatedAvgLineSize = 0;
    }

    public RowBuffer(RowBuffer next) {
        this(1, next);
    }

    public RowBuffer(int capacity) {
        this(capacity, null);
    }

    public RowBuffer() {
        this(null);
    }

    public Row[] getRowArray() {
        return this.rowArray;
    }

    public boolean containsEndRow() {
        return this.count > 0 && this.rowArray[this.count - 1].pos == -1;
    }

    public void setNextRowBuffer(RowBuffer buffer) {
        this.next = buffer;
    }

    public RowBuffer nextRowBuffer() {
        this.next.count = 0;
        this.next.byteCount = 0;
        this.next.idx = 0;
        this.next.estimatedAvgLineSize = 0;
        return this.next;
    }

    public boolean enlarge(int newsize) {
        int oldcapacity = this.capacity;
        if (this.byteCount < this.maxBytes) {
            this.capacity = Math.min(newsize, this.rowArray.length);
        }
        return this.capacity != oldcapacity;
    }

    public void reduce(int newsize) {
        this.capacity = Math.max(newsize, 1);
    }

    public Row get(int i) {
        return this.rowArray[i];
    }

    public void add(Row r) {
        this.rowArray[this.count++] = r;
        if (this.count < NUM_LINES_TO_ESTIMATE_LINE_SIZE) {
            int lineBytes = r.length();
            this.estimatedAvgLineSize = this.count == 1 ? lineBytes : (this.estimatedAvgLineSize * (this.count - 1) + lineBytes) / this.count;
            this.byteCount += lineBytes;
        } else {
            this.byteCount += this.estimatedAvgLineSize;
        }
    }

    public Row pop() {
        return this.rowArray[--this.count];
    }

    @Override
    public boolean hasNext() {
        return this.available() && this.rowArray[this.idx].pos != -1;
    }

    @Override
    public Row next() {
        return this.rowArray[this.idx++];
    }

    public synchronized void clear() {
        this.count = 0;
        this.byteCount = 0;
        this.idx = 0;
        this.estimatedAvgLineSize = 0;
    }

    public int getIndex() {
        return this.idx;
    }

    public boolean isWaiting() {
        return !this.available() && !this.isFull();
    }

    public boolean available() {
        return this.idx < this.count;
    }

    public boolean isFull() {
        return this.count == this.capacity || this.byteCount >= this.maxBytes;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    public int getCapacity() {
        return this.capacity;
    }
}

