/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gor.util;

import org.gorpipe.gor.util.GLogGamma;

public class GFisherExact2by2 {
    private GFisherExact2by2() {
    }

    public static double compute(int A, int B, int C, int D) {
        int steps;
        int n = A + B + C + D;
        double F = GLogGamma.get(A + B) + GLogGamma.get(C + D) + GLogGamma.get(A + C) + GLogGamma.get(B + D) - GLogGamma.get(n);
        double P = 0.0;
        for (int i = steps = Math.min(C, B); i >= 0; --i) {
            P += Math.exp(F - GLogGamma.get(A + i) - GLogGamma.get(D + i) - GLogGamma.get(B - i) - GLogGamma.get(C - i));
        }
        return P;
    }

    public static double computeOneTailed(int A, int B, int C, int D) {
        int n = A + B + C + D;
        double F = GLogGamma.get(A + B) + GLogGamma.get(C + D) + GLogGamma.get(A + C) + GLogGamma.get(B + D) - GLogGamma.get(n);
        int minAD = Math.min(A, D);
        int minBC = Math.min(B, C);
        double Pleft = 0.0;
        for (int i = minAD; i >= 0; --i) {
            Pleft += Math.exp(F - GLogGamma.get(A - i) - GLogGamma.get(D - i) - GLogGamma.get(B + i) - GLogGamma.get(C + i));
        }
        double Pright = 0.0;
        for (int i = minBC; i >= 0; --i) {
            Pright += Math.exp(F - GLogGamma.get(A + i) - GLogGamma.get(D + i) - GLogGamma.get(B - i) - GLogGamma.get(C - i));
        }
        return Math.min(Pleft, Pright);
    }

    public static double computeTwoTailed(int A, int B, int C, int D) {
        int n = A + B + C + D;
        double F = GLogGamma.get(A + B) + GLogGamma.get(C + D) + GLogGamma.get(A + C) + GLogGamma.get(B + D) - GLogGamma.get(n);
        double Pbase = Math.exp(F - GLogGamma.get(A) - GLogGamma.get(D) - GLogGamma.get(B) - GLogGamma.get(C));
        int minAD = Math.min(A, D);
        int minBC = Math.min(B, C);
        double Ptails = 0.0;
        for (int i = -minAD; i <= minBC; ++i) {
            double P = Math.exp(F - GLogGamma.get(A + i) - GLogGamma.get(D + i) - GLogGamma.get(B - i) - GLogGamma.get(C - i));
            if (!(P <= Pbase)) continue;
            Ptails += P;
        }
        return Ptails;
    }
}

