/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import gorsat.process.GorInputSources;
import gorsat.process.GorPipeCommands;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="help", header={"Displays help information about the specified command"}, synopsisHeading="%nUsage: ", helpCommand=true, description={"%nWhen no COMMAND is given, the usage help for the main command is displayed.", "If a COMMAND is specified, the help for that command is shown.%n"})
public class HelpCmd
implements CommandLine.IHelpCommandInitializable2,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(HelpCmd.class);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, descriptionKey="helpCommand.help", description={"Show usage help for the help command and exit."})
    private boolean helpRequested;
    @CommandLine.Parameters(paramLabel="COMMAND", descriptionKey="helpCommand.command", description={"The COMMAND to display the usage help message for."})
    private final String[] commands = new String[0];
    private CommandLine self;
    private PrintWriter outWriter;
    private PrintWriter errWriter;
    private CommandLine.Help.ColorScheme colorScheme;
    private Map<String, String> gorHelpMap;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        CommandLine parent;
        if (this.gorHelpMap == null) {
            this.gorHelpMap = this.loadHelpFiles();
        }
        if (this.self == null) {
            return;
        }
        CommandLine commandLine = parent = this.self.getParent();
        if (parent == null) {
            return;
        }
        if (this.commands.length > 0) {
            CommandLine subcommand = (CommandLine)parent.getSubcommands().get(this.commands[0]);
            if (subcommand != null) {
                subcommand.usage(this.outWriter, this.colorScheme);
                return;
            } else {
                String cmd = this.commands[0].toUpperCase();
                if (this.gorHelpMap == null) throw new CommandLine.ParameterException(parent, "Unknown subcommand '" + this.commands[0] + "'.", null, this.commands[0]);
                if (!this.gorHelpMap.containsKey(cmd)) throw new CommandLine.ParameterException(parent, "Unknown subcommand '" + this.commands[0] + "'.", null, this.commands[0]);
                String helpMsg = this.gorHelpMap.get(cmd);
                this.outWriter.println(helpMsg);
            }
            return;
        } else {
            parent.usage(this.outWriter, this.colorScheme);
            this.outWriter.println("\nGOR input sources:");
            CharSequence[] inputSources = GorInputSources.getInputSources();
            this.outWriter.println(String.join((CharSequence)", ", inputSources));
            this.outWriter.println("\nGOR pipe commands:");
            CharSequence[] pipeCommands = GorPipeCommands.getGorCommands();
            this.outWriter.println(String.join((CharSequence)", ", pipeCommands));
        }
    }

    public void init(CommandLine helpCommandLine, CommandLine.Help.ColorScheme colorScheme, PrintWriter outWriter, PrintWriter errWriter) {
        this.self = helpCommandLine;
        this.colorScheme = colorScheme;
        this.outWriter = outWriter;
        this.errWriter = errWriter;
    }

    private Map<String, String> loadHelpFiles() {
        String[] helpFiles;
        ArrayList<String> helpList = new ArrayList<String>();
        for (String helpFileEntry : helpFiles = new String[]{"gor_commands_help.txt", "gor_functions_help.txt"}) {
            URI helpJarURL;
            try {
                helpJarURL = this.getClass().getClassLoader().getResource(helpFileEntry).toURI();
            }
            catch (URISyntaxException e) {
                log.warn("Failed loading help files", (Throwable)e);
                return null;
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            try (FileSystem fileSystem = FileSystems.newFileSystem(helpJarURL, env);){
                helpList.addAll(Files.readAllLines(Paths.get(helpJarURL), StandardCharsets.ISO_8859_1));
            }
            catch (Exception e) {
                log.warn("Failed loading help files", (Throwable)e);
                return null;
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HelpCmd.listToMap(helpList.toArray(new String[0]), map);
        return map;
    }

    static void listToMap(String[] helpStrings, Map<String, String> helpMap) {
        String name = null;
        StringBuilder contents = null;
        for (String helpLine : helpStrings) {
            if (helpLine.startsWith("->")) {
                if (name != null) {
                    helpMap.put(name, contents.toString());
                }
                name = helpLine.substring(2).toUpperCase();
                contents = new StringBuilder();
                continue;
            }
            if (contents == null) continue;
            contents.append(helpLine);
            contents.append("\n");
        }
        if (name != null) {
            helpMap.put(name, contents.toString());
        }
    }
}

