/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import org.gorpipe.gorshell.Commands;
import picocli.CommandLine;

@CommandLine.Command(name="script", description={"Run a GOR script from a file"})
public class ScriptCmd
implements Runnable {
    @CommandLine.ParentCommand
    private Commands parent;
    @CommandLine.Parameters(arity="0..1")
    private String scriptFile;
    @CommandLine.Option(names={"-s"}, description={"Saves the current script to the given file"})
    private boolean save;
    @CommandLine.Option(names={"-c"}, description={"Clears the current script"})
    private boolean clear;

    @Override
    public void run() {
        if (this.scriptFile != null) {
            if (this.save) {
                this.parent.getShell().saveScript(this.scriptFile);
            } else {
                this.parent.getShell().script(this.scriptFile);
            }
        } else if (this.clear) {
            this.parent.getShell().clearScript();
        } else {
            this.parent.getShell().showScript();
        }
    }
}

