/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.gorshell;

import org.gorpipe.gorshell.Commands;
import org.gorpipe.gorshell.GorShell;
import picocli.CommandLine;

@CommandLine.Command(name="set", description={"Set various settings for the shell"}, subcommands={FileCache.class, RequestStats.class, Timing.class, DisplayResults.class, ConfigFile.class})
public class SetCmd
implements Runnable {
    @CommandLine.ParentCommand
    Commands parent;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    GorShell getShell() {
        return this.parent.getShell();
    }

    @Override
    public void run() {
        throw new CommandLine.ParameterException(this.spec.commandLine(), "Missing required subcommand");
    }

    @CommandLine.Command(name="config", description={"Set the config file for GOR"})
    public static class ConfigFile
    implements Runnable {
        @CommandLine.ParentCommand
        private SetCmd parent;
        @CommandLine.Parameters(index="0", arity="0..1")
        private String configFile;

        @Override
        public void run() {
            this.parent.getShell().setConfigFile(this.configFile);
        }
    }

    @CommandLine.Command(name="dr", description={"Enable/disable display of results - not displaying results can be useful when timing"})
    public static class DisplayResults
    implements Runnable {
        @CommandLine.ParentCommand
        private SetCmd parent;
        @CommandLine.Parameters(index="0")
        private final State state = State.OFF;

        @Override
        public void run() {
            this.parent.getShell().setDisplayResults(this.state == State.ON);
        }
    }

    @CommandLine.Command(name="timing", description={"Enable/disable timing for gor queries"})
    public static class Timing
    implements Runnable {
        @CommandLine.ParentCommand
        private SetCmd parent;
        @CommandLine.Parameters(index="0")
        private final State state = State.OFF;

        @Override
        public void run() {
            this.parent.getShell().setTimingEnabled(this.state == State.ON);
        }
    }

    @CommandLine.Command(name="rs", description={"Request stats"})
    public static class RequestStats
    implements Runnable {
        @CommandLine.ParentCommand
        private SetCmd parent;
        @CommandLine.Parameters(index="0")
        private final State state = State.OFF;

        @Override
        public void run() {
            this.parent.getShell().setRequestStatsEnabled(this.state == State.ON);
        }
    }

    @CommandLine.Command(name="fc", description={"Manipulate file cache"})
    static class FileCache
    implements Runnable {
        @CommandLine.ParentCommand
        private SetCmd parent;
        @CommandLine.Parameters(index="0")
        private final State state = State.OFF;

        FileCache() {
        }

        @Override
        public void run() {
            this.parent.getShell().setFileCacheEnabled(this.state == State.ON);
        }
    }

    static enum State {
        OFF,
        ON;

    }
}

