/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.jessica;

import gorsat.Commands.RowHeader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.gorpipe.gor.model.Row;
import org.gorpipe.jessica.GorQueryHandler;
import org.gorpipe.jessica.PipeStepInfo;

public class MainWindow
extends JFrame
implements DocumentListener,
ActionListener {
    private final transient GorQueryHandler gorQueryHandler;
    private final JTextArea input;
    private final JTextArea output;
    private final JCheckBox autoRun;
    private final JLabel status;
    private final DefaultTableModel tableData;

    public MainWindow(GorQueryHandler il) {
        super("Jessica");
        this.gorQueryHandler = il;
        this.setDefaultCloseOperation(3);
        JLabel inputLabel = new JLabel("Enter command:");
        this.input = new JTextArea();
        this.input.getDocument().addDocumentListener(this);
        this.autoRun = new JCheckBox("Auto-run", true);
        JButton runButton = new JButton("Run");
        runButton.setActionCommand("run");
        runButton.addActionListener(this);
        this.output = new JTextArea();
        this.output.setEditable(false);
        JScrollPane outputScroll = new JScrollPane(this.output);
        this.status = new JLabel("Status message");
        this.tableData = new DefaultTableModel();
        JTable table = new JTable(this.tableData);
        JScrollPane tableScroll = new JScrollPane(table);
        table.setFillsViewportHeight(true);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        GroupLayout.ParallelGroup hGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup h1 = layout.createSequentialGroup();
        GroupLayout.ParallelGroup h2 = layout.createParallelGroup(GroupLayout.Alignment.TRAILING);
        h1.addContainerGap();
        h2.addComponent(outputScroll, GroupLayout.Alignment.LEADING, -1, 450, Short.MAX_VALUE);
        h2.addComponent(tableScroll, GroupLayout.Alignment.LEADING, -1, 450, Short.MAX_VALUE);
        h2.addComponent(this.status, GroupLayout.Alignment.LEADING, -1, 450, Short.MAX_VALUE);
        GroupLayout.SequentialGroup h3 = layout.createSequentialGroup();
        h3.addComponent(inputLabel);
        h3.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        h3.addComponent(this.input, -1, 900, Short.MAX_VALUE);
        h3.addComponent(runButton);
        h3.addComponent(this.autoRun);
        h2.addGroup(h3);
        h1.addGroup(h2);
        h1.addContainerGap();
        hGroup.addGroup(GroupLayout.Alignment.TRAILING, h1);
        layout.setHorizontalGroup(hGroup);
        GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(GroupLayout.Alignment.LEADING);
        GroupLayout.SequentialGroup v1 = layout.createSequentialGroup();
        v1.addContainerGap();
        GroupLayout.ParallelGroup v2 = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
        v2.addComponent(inputLabel);
        v2.addComponent(this.input, -1, 120, Short.MAX_VALUE);
        v2.addComponent(runButton);
        v2.addComponent(this.autoRun);
        v1.addGroup(v2);
        v1.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        v1.addComponent(outputScroll, -1, 233, Short.MAX_VALUE);
        v1.addComponent(tableScroll, -1, 233, Short.MAX_VALUE);
        v1.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
        v1.addComponent(this.status);
        v1.addContainerGap();
        vGroup.addGroup(v1);
        layout.setVerticalGroup(vGroup);
        this.pack();
    }

    private void handleInput() {
        this.gorQueryHandler.setQuery(this.input.getText());
        boolean parseSuccessful = this.gorQueryHandler.parse();
        if (parseSuccessful) {
            if (this.autoRun.isSelected()) {
                this.runQueryAndShowResults();
            } else {
                this.clearResults();
                this.status.setText("OK");
            }
        } else {
            this.clearResults();
            this.status.setText("Error");
        }
        this.showPipeDescription();
    }

    private void clearResults() {
        this.tableData.setDataVector(new Vector(), new Vector());
    }

    private void showPipeDescription() {
        PipeStepInfo[] pipeStepInfos = this.gorQueryHandler.getSteps();
        String pipeDescription = this.getPipeDescription(pipeStepInfos);
        Throwable exception = this.gorQueryHandler.getException();
        String exceptionDescription = exception == null ? "" : exception.getMessage();
        this.output.setText(pipeDescription + exceptionDescription);
    }

    private void runQueryAndShowResults() {
        this.gorQueryHandler.run();
        RowHeader outputHeader = this.gorQueryHandler.getOutputHeader();
        if (outputHeader != null) {
            String[] namesWithTypes = outputHeader.columnNamesWithTypes();
            Vector columnNames = new Vector(namesWithTypes.length);
            Collections.addAll(columnNames, namesWithTypes);
            Vector<Vector<String>> values = this.rowArrayToVector(this.gorQueryHandler.getResults());
            this.tableData.setDataVector(values, columnNames);
            Throwable exception = this.gorQueryHandler.getException();
            if (exception != null) {
                this.status.setText("Exception thrown");
            } else {
                this.status.setText("OK");
            }
        } else {
            this.status.setText("No output header");
        }
    }

    private Vector<Vector<String>> rowArrayToVector(Row[] result) {
        Vector<Vector<String>> values = new Vector<Vector<String>>(result.length);
        for (Row r : result) {
            Vector<String> rowValues = this.rowToStringVector(r);
            values.add(rowValues);
        }
        return values;
    }

    private Vector<String> rowToStringVector(Row r) {
        String[] fields = r.getAllCols().toString().split("\t");
        Vector<String> rowValues = new Vector<String>(fields.length);
        Collections.addAll(rowValues, fields);
        return rowValues;
    }

    private void handleRun() {
        this.runQueryAndShowResults();
    }

    private String getPipeDescription(PipeStepInfo[] pipeStepInfos) {
        StringBuilder sb = new StringBuilder();
        for (PipeStepInfo stepInfo : pipeStepInfos) {
            sb.append(stepInfo.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleInput();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleInput();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("run".equals(e.getActionCommand())) {
            this.handleRun();
        }
    }
}

