/*
 * Decompiled with CFR 0.152.
 */
package org.gorpipe.logging;

import ch.qos.logback.classic.LoggerContext;
import java.util.ArrayList;
import java.util.Map;
import net.logstash.logback.argument.StructuredArgument;
import net.logstash.logback.argument.StructuredArguments;
import org.gorpipe.base.logging.ProcessIdConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class GorLogbackUtil {
    private static final Logger logger = LoggerFactory.getLogger(GorLogbackUtil.class);
    public static final Marker MARKER_AUDIT = MarkerFactory.getDetachedMarker((String)"audit");
    public static final Marker MARKER_SECURITY = MarkerFactory.getDetachedMarker((String)"security");
    public static final Marker MARKER_SYSTEM = MarkerFactory.getDetachedMarker((String)"system");
    private static final String UNKNOWN_PROPERTY = "";

    private GorLogbackUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void logServiceStatus(Logger logger) {
        try {
            logger.info(MARKER_SYSTEM, "System Information", GorLogbackUtil.getSystemProperties());
        }
        catch (Exception e) {
            logger.warn("Error when logging out system information");
        }
    }

    private static Object[] getSystemProperties() {
        return new Object[]{StructuredArguments.value((String)"os.arch", (Object)System.getProperty("os.arch", UNKNOWN_PROPERTY)), StructuredArguments.value((String)"os.name", (Object)System.getProperty("os.name", UNKNOWN_PROPERTY)), StructuredArguments.value((String)"os.version", (Object)System.getProperty("os.version", UNKNOWN_PROPERTY)), StructuredArguments.value((String)"gor.version", (Object)GorLogbackUtil.getGORVersion()), StructuredArguments.value((String)"java.vendor", (Object)System.getProperty("java.vendor", UNKNOWN_PROPERTY)), StructuredArguments.value((String)"java.version", (Object)System.getProperty("java.version", UNKNOWN_PROPERTY))};
    }

    private static String getEnv(String key, String defaultValue) {
        String envValue = System.getenv(key);
        if (envValue != null && envValue.length() > 0) {
            return envValue;
        }
        return defaultValue;
    }

    public static void initServiceLog() {
        GorLogbackUtil.initLog(UNKNOWN_PROPERTY);
    }

    public static void initLog(String appName) {
        try {
            String serviceName = System.getProperty("service.name", UNKNOWN_PROPERTY);
            if (appName.equals(UNKNOWN_PROPERTY)) {
                appName = serviceName;
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            context.putProperty("processid", ProcessIdConverter.getProcessId());
            context.putProperty("gor_service", serviceName);
            context.putProperty("gor_app", appName);
            context.putProperty("gor_version", GorLogbackUtil.getGORVersion());
            context.putProperty("environment", GorLogbackUtil.getEnv("ENVIRONMENT_NAME", "unkown_environment"));
            context.putProperty("csa_env", GorLogbackUtil.getEnv("CSA_ENV", "unkown"));
            MDC.put((String)"processid", (String)ProcessIdConverter.getProcessId());
            MDC.put((String)"gor_service", (String)serviceName);
        }
        catch (Exception e) {
            logger.warn("Failed to initialize service status");
        }
    }

    public static void terminateServiceLog() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.stop();
    }

    private static String getGORVersion() {
        String version = GorLogbackUtil.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = UNKNOWN_PROPERTY;
        }
        return version;
    }

    public static Object[] getValuesFromMap(Map<String, String> map) {
        ArrayList<StructuredArgument> values = new ArrayList<StructuredArgument>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            values.add(StructuredArguments.value((String)entry.getKey(), (Object)entry.getValue()));
        }
        return values.toArray();
    }
}

