/*
 * Decompiled with CFR 0.152.
 */
package gorsat.Utilities;

import gorsat.Commands.BinaryWrite;
import gorsat.Commands.CommandInfo;
import gorsat.Commands.CommandParseUtilities$;
import gorsat.Commands.Write;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import org.gorpipe.exceptions.GorParsingException;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;

public final class Utilities$ {
    public static Utilities$ MODULE$;

    static {
        new Utilities$();
    }

    public String makeTempFile(String value, String cacheDir) {
        String hash = new StringBuilder(0).append(Math.abs(value.hashCode())).toString();
        Path cacheFile = cacheDir != null ? Paths.get(cacheDir, new String[0]).resolve(hash) : Files.createTempFile(hash, ".sh", new FileAttribute[0]);
        Files.write(cacheFile, value.getBytes(), new OpenOption[0]);
        scala.collection.immutable.Set perms = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_READ}));
        Files.setPosixFilePermissions(cacheFile, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)perms).asJava());
        return ((Object)cacheFile.toAbsolutePath()).toString();
    }

    public boolean queryContainsCommand(String query, CommandInfo commandInfo) {
        return query.toUpperCase().contains(commandInfo.name());
    }

    public boolean queryContainsWriteCommand(String query) {
        return this.queryContainsCommand(query, new Write()) || this.queryContainsCommand(query, new BinaryWrite());
    }

    public String getWriteFilename(String query) {
        CommandInfo command = this.getWriteCommand(query);
        if (command == null) {
            return null;
        }
        int writeIndex = query.toUpperCase().indexOf(new StringBuilder(1).append(command.name()).append(" ").toString());
        if (writeIndex < 0) {
            throw new GorParsingException("Unable to get the filename for the write command of ", query, "");
        }
        String queryRemainder = query.substring(writeIndex + command.name().length() + 1);
        String commandRemainder = CommandParseUtilities$.MODULE$.quoteSafeSplit(queryRemainder, '|')[0];
        String[] commandArgs = CommandParseUtilities$.MODULE$.quoteSafeSplit(commandRemainder, ' ');
        String[] arguments = command.validateArguments(commandArgs);
        return arguments[0];
    }

    public CommandInfo getWriteCommand(String query) {
        if (this.queryContainsCommand(query, new Write())) {
            return new Write();
        }
        if (this.queryContainsCommand(query, new BinaryWrite())) {
            return new BinaryWrite();
        }
        return null;
    }

    private Utilities$() {
        MODULE$ = this;
    }
}

